/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass;

import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;

@ElementClass.Single
public interface BranchPoint
extends ElementHandler {
    public Direction getDirectionPreference(IElement var1, Direction var2);

    public void setDirectionPreference(IElement var1, Direction var2);

    public static enum Direction {
        Any,
        Horizontal,
        Vertical;


        public static Direction toDirection(boolean horizontal, boolean vertical) {
            if (horizontal && vertical) {
                throw new IllegalArgumentException("branch point cannot be both horizontal and vertical");
            }
            if (horizontal) {
                return Horizontal;
            }
            if (vertical) {
                return Vertical;
            }
            return Any;
        }

        public Direction toggleDetermined() {
            switch (this) {
                case Horizontal: {
                    return Vertical;
                }
                case Vertical: {
                    return Horizontal;
                }
            }
            return Any;
        }

        public Direction cycleNext() {
            Direction[] dirs = Direction.values();
            int newOrdinal = this.ordinal() + 1;
            return dirs[newOrdinal >= dirs.length ? 0 : newOrdinal];
        }

        public Direction cyclePrevious() {
            Direction[] dirs = Direction.values();
            int newOrdinal = this.ordinal() - 1;
            return dirs[newOrdinal < 0 ? dirs.length - 1 : newOrdinal];
        }
    }
}

