/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.plan.PostCommitOp;
import org.simantics.scl.compiler.elaboration.chr.plan.PreCommitOp;
import org.simantics.scl.compiler.elaboration.chr.planning.QueryPlanningContext;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public class CHRQuery
extends Symbol {
    public CHRLiteral[] literals;

    public CHRQuery(long location, CHRLiteral[] literals) {
        this.literals = literals;
        this.location = location;
    }

    public void resolve(TranslationContext context) {
        CHRLiteral[] cHRLiteralArray = this.literals;
        int n = this.literals.length;
        int n2 = 0;
        while (n2 < n) {
            CHRLiteral literal = cHRLiteralArray[n2];
            literal.resolve(context);
            ++n2;
        }
    }

    public void checkType(TypingContext context) {
        CHRLiteral[] cHRLiteralArray = this.literals;
        int n = this.literals.length;
        int n2 = 0;
        while (n2 < n) {
            CHRLiteral literal = cHRLiteralArray[n2];
            literal.checkType(context);
            ++n2;
        }
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        CHRLiteral[] cHRLiteralArray = this.literals;
        int n = this.literals.length;
        int n2 = 0;
        while (n2 < n) {
            CHRLiteral literal = cHRLiteralArray[n2];
            literal.collectVars(allVars, vars);
            ++n2;
        }
    }

    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            CHRLiteral[] cHRLiteralArray = this.literals;
            int n = this.literals.length;
            int n2 = 0;
            while (n2 < n) {
                CHRLiteral literal = cHRLiteralArray[n2];
                literal.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    public boolean createQueryPlan(QueryPlanningContext context, Expression inputFact, int activeLiteralId, CHRConstraint initConstraint) {
        try {
            int i = 0;
            while (i < this.literals.length) {
                CHRLiteral literal = this.literals[i];
                if (i == activeLiteralId) {
                    context.activate(literal, inputFact, i);
                } else {
                    context.add(literal, i);
                }
                ++i;
            }
            if (activeLiteralId == -1 && inputFact != null) {
                context.addInitFact(initConstraint, inputFact);
            }
            return context.createQueryPlan();
        }
        catch (Exception e) {
            throw InternalCompilerError.injectLocation(this.location, e);
        }
    }

    public void simplify(SimplificationContext context) {
        CHRLiteral[] cHRLiteralArray = this.literals;
        int n = this.literals.length;
        int n2 = 0;
        while (n2 < n) {
            CHRLiteral literal = cHRLiteralArray[n2];
            literal.simplify(context);
            ++n2;
        }
    }

    public void createEnforcePlan(QueryPlanningContext context, int priority) {
        context.addPlanOp(new PreCommitOp(this.location));
        CHRLiteral[] cHRLiteralArray = this.literals;
        int n = this.literals.length;
        int n2 = 0;
        while (n2 < n) {
            CHRLiteral literal = cHRLiteralArray[n2];
            context.claim(context, literal);
            ++n2;
        }
        context.addPlanOp(new PostCommitOp(this.location, priority));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
        visitor.visit(this);
        return b.toString();
    }

    public CHRQuery replace(ReplaceContext context) {
        CHRLiteral[] newLiterals = new CHRLiteral[this.literals.length];
        int i = 0;
        while (i < this.literals.length) {
            newLiterals[i] = this.literals[i].replace(context);
            ++i;
        }
        return new CHRQuery(this.location, newLiterals);
    }
}

