/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.ComparisonFunction;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class JavaComparisonOperation
extends FunctionValue
implements ComparisonFunction {
    public static final JavaComparisonOperation IEQUAL = new JavaComparisonOperation("==", Types.INTEGER);
    public static final JavaComparisonOperation INOT_EQUAL = new JavaComparisonOperation("!=", Types.INTEGER);
    public static final JavaComparisonOperation ILESS = new JavaComparisonOperation("<", Types.INTEGER);
    public static final JavaComparisonOperation ILESS_OR_EQUAL = new JavaComparisonOperation("<=", Types.INTEGER);
    public static final JavaComparisonOperation IGREATER = new JavaComparisonOperation(">", Types.INTEGER);
    public static final JavaComparisonOperation IGREATER_OR_EQUAL = new JavaComparisonOperation(">=", Types.INTEGER);
    String op;

    public JavaComparisonOperation(String op, Type type) {
        super(TVar.EMPTY_ARRAY, Types.NO_EFFECTS, Types.BOOLEAN, type, type);
        this.op = op;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        JavaTypeTranslator tt = mb.getJavaTypeTranslator();
        Label thenBranch = mb.createLabel();
        Label joinPoint = mb.createLabel();
        Type type = this.parameterTypes[0];
        mb.push(parameters[0], type);
        mb.push(parameters[1], type);
        mb.ifComparisonBranch(thenBranch, this.op, tt.toTypeDesc(type));
        mb.loadConstant(false);
        mb.branch(joinPoint);
        mb.setLocation(thenBranch);
        mb.loadConstant(true);
        mb.setLocation(joinPoint);
        return this.getReturnType();
    }

    public String toString() {
        return "(" + this.op + ")";
    }

    @Override
    public void generateCondition(MethodBuilder mb, Val[] parameters, Cont then_, Cont else_) {
        JavaTypeTranslator tt = mb.getJavaTypeTranslator();
        Type type = this.parameterTypes[0];
        mb.push(parameters[0], type);
        mb.push(parameters[1], type);
        mb.ifComparisonBranch(mb.getLabel(then_), this.op, tt.toTypeDesc(type));
        mb.jump(else_);
        mb.ensureExists(then_);
    }
}

