/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.reporting.SCLReporting;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncUtils.class);
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private static final ThreadFactory threadFactory = r -> {
        Thread t = new Thread(r, "scl-async-utils-thread-" + threadCount.incrementAndGet());
        t.setDaemon(true);
        return t;
    };
    private static final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), threadFactory);

    public static void runAsync(Function f) {
        SCLContext context = SCLContext.createDerivedContext();
        scheduledExecutor.submit(() -> {
            SCLContext.push(context);
            try {
                try {
                    f.apply(Tuple0.INSTANCE);
                }
                catch (Exception e) {
                    LOGGER.error("Could not execute async", (Throwable)e);
                    AsyncUtils.printError(e);
                    SCLContext.pop();
                }
            }
            finally {
                SCLContext.pop();
            }
        });
    }

    public static List<Object> pmap(Function f, List<Object> l) {
        return Arrays.asList(l.parallelStream().map(a -> f.apply(a)).toArray());
    }

    public static Future<?> submitAsync(Function f) {
        SCLContext context = SCLContext.createDerivedContext();
        return scheduledExecutor.submit(() -> {
            SCLContext.push(context);
            try {
                Object r = f.apply(Tuple0.INSTANCE);
                return r;
            }
            catch (Throwable t) {
                LOGGER.error("Could not execute async {}", (Object)f, (Object)t);
                AsyncUtils.printError(t);
                return null;
            }
            finally {
                SCLContext.pop();
            }
        });
    }

    public static List<Future<Object>> invokeAllAsync(Collection<Function> fs) throws InterruptedException {
        return AsyncUtils.invokeAllAsyncWithTimeout(fs, -1L, null);
    }

    private static Callable<Object> toCallable(SCLContext context, Function f) {
        return () -> {
            SCLContext.push(context);
            try {
                Object r = f.apply(Tuple0.INSTANCE);
                return r;
            }
            catch (Throwable t) {
                LOGGER.error("Could not invoke {}", (Object)f, (Object)t);
                AsyncUtils.printError(t);
                return null;
            }
            finally {
                SCLContext.pop();
            }
        };
    }

    public static List<Future<Object>> invokeAllAsyncWithTimeout(Collection<Function> fs, long timeout, TimeUnit unit) throws InterruptedException {
        SCLContext context = SCLContext.createDerivedContext();
        List invokables = fs.stream().map(f -> AsyncUtils.toCallable(context, f)).collect(Collectors.toList());
        try {
            if (timeout == -1L) {
                return scheduledExecutor.invokeAll(invokables);
            }
            return scheduledExecutor.invokeAll(invokables, timeout, unit);
        }
        catch (Throwable t) {
            LOGGER.error("Could not invoke all", t);
            throw t;
        }
    }

    public static Object invokeAnyAsync(Collection<Function> fs) throws InterruptedException, ExecutionException, TimeoutException {
        return AsyncUtils.invokeAnyAsyncWithTimeout(fs, -1L, null);
    }

    public static Object invokeAnyAsyncWithTimeout(Collection<Function> fs, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        SCLContext context = SCLContext.createDerivedContext();
        Collection invokables = fs.stream().map(f -> AsyncUtils.toCallable(context, f)).collect(Collectors.toList());
        try {
            if (timeout == -1L) {
                return scheduledExecutor.invokeAny(invokables);
            }
            return scheduledExecutor.invokeAny(invokables, timeout, unit);
        }
        catch (Throwable t) {
            LOGGER.error("Could not invoke any", t);
            throw t;
        }
    }

    public static Future<?> scheduleAtFixedRate(Function f, long initialDelay, long period, TimeUnit unit) {
        SCLContext context = SCLContext.createDerivedContext();
        return scheduledExecutor.scheduleAtFixedRate(() -> {
            SCLContext.push(context);
            try {
                try {
                    f.apply(Tuple0.INSTANCE);
                }
                catch (Throwable t) {
                    LOGGER.error("Could not execute {} with fixed rate {} {}", new Object[]{f, initialDelay, period, t});
                    AsyncUtils.printError(t);
                    SCLContext.pop();
                }
            }
            finally {
                SCLContext.pop();
            }
        }, initialDelay, period, unit);
    }

    public static Future<?> scheduleWithFixedDelay(Function f, long initialDelay, long period, TimeUnit unit) {
        SCLContext context = SCLContext.createDerivedContext();
        return scheduledExecutor.scheduleWithFixedDelay(() -> {
            SCLContext.push(context);
            try {
                try {
                    f.apply(Tuple0.INSTANCE);
                }
                catch (Throwable t) {
                    LOGGER.error("Could not execute {} with fixed delay {} {}", new Object[]{f, initialDelay, period, t});
                    AsyncUtils.printError(t);
                    SCLContext.pop();
                }
            }
            finally {
                SCLContext.pop();
            }
        }, initialDelay, period, unit);
    }

    public static Future<?> schedule(Function f, long delay, TimeUnit unit) {
        SCLContext context = SCLContext.createDerivedContext();
        return scheduledExecutor.schedule(() -> {
            SCLContext.push(context);
            try {
                Object r = f.apply(Tuple0.INSTANCE);
                return r;
            }
            catch (Throwable t) {
                LOGGER.error("Could not schedule {} with delay {}", new Object[]{f, delay, t});
                AsyncUtils.printError(t);
                return null;
            }
            finally {
                SCLContext.pop();
            }
        }, delay, unit);
    }

    private static void printError(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        SCLReporting.printError(sw.toString());
    }
}

