/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Write;
import org.simantics.issues.Severity;
import org.simantics.issues.common.IssueUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.issues.ui.handler.TagAction;
import org.simantics.issues.ui.internal.Activator;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class MenuActions
extends DynamicMenuContribution {
    protected Object[] getSelectedObjects() {
        ISelection sel = this.getSelection();
        List resources = ISelectionUtils.getPossibleKeys((Object)sel, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        return resources.toArray();
    }

    List<Resource> toResources(Object[] array) {
        Resource[] a = new Resource[array.length];
        int i = 0;
        while (i < array.length) {
            a[i] = (Resource)array[i];
            ++i;
        }
        return Arrays.asList(a);
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        if (selection.length == 0) {
            return new IContributionItem[0];
        }
        List<Resource> input = this.toResources(selection);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        int issueCount = 0;
        int hiddenCount = 0;
        int resolvedCount = 0;
        int userIssueCount = 0;
        for (Resource r : input) {
            boolean userIssue;
            boolean isIssue = graph.isInstanceOf(r, ISSUE.Issue);
            if (isIssue) {
                ++issueCount;
                if (graph.hasStatement(r, ISSUE.Hidden)) {
                    ++hiddenCount;
                }
                if (graph.hasStatement(r, ISSUE.Resolved)) {
                    ++resolvedCount;
                }
            }
            if (!(userIssue = graph.hasStatement(r, ISSUE.UserIssue))) continue;
            ++userIssueCount;
        }
        boolean allHidden = hiddenCount == selection.length;
        boolean allResolved = resolvedCount == selection.length;
        boolean allUserIssues = userIssueCount == selection.length;
        boolean allIssueSelection = issueCount == selection.length;
        ArrayList<Object> actions = new ArrayList<Object>(2);
        if (!allHidden && allIssueSelection) {
            actions.add(new ActionContributionItem(this.hideAction(input)));
        }
        if (hiddenCount > 0 || allHidden && allIssueSelection) {
            actions.add(new ActionContributionItem(this.unhideAction(input)));
        }
        if (!allResolved && allIssueSelection) {
            actions.add(new ActionContributionItem(this.resolveAction(input)));
        }
        if (resolvedCount > 0 || allResolved && allIssueSelection) {
            actions.add(new ActionContributionItem(this.unresolveAction(input)));
        }
        if (allUserIssues) {
            actions.add(this.setSeverityAction(input));
        }
        return actions.toArray(new IContributionItem[actions.size()]);
    }

    private IAction unhideAction(List<Resource> input) {
        return this.tagAction("Unhide", Activator.UNHIDE_ICON, "http://www.simantics.org/Issue-1.2/Hidden", false, input);
    }

    private IAction hideAction(List<Resource> input) {
        return this.tagAction("Hide", Activator.HIDE_ICON, "http://www.simantics.org/Issue-1.2/Hidden", true, input);
    }

    private IAction resolveAction(List<Resource> input) {
        return this.tagAction("Mark Resolved", Activator.RESOLVE_ICON, "http://www.simantics.org/Issue-1.2/Resolved", true, input);
    }

    private IAction unresolveAction(List<Resource> input) {
        return this.tagAction("Mark Unresolved", Activator.UNRESOLVE_ICON, "http://www.simantics.org/Issue-1.2/Resolved", false, input);
    }

    private IAction tagAction(String label, ImageDescriptor image, String tagURI, boolean tag, List<Resource> input) {
        return new TagAction(label, image, "issues", tagURI, tag, input);
    }

    private IContributionItem setSeverityAction(final List<Resource> userIssues) {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem setSeverityItem = new MenuItem(menu, 64);
                setSeverityItem.setText("Set Severity");
                Menu setSeverity = new Menu(menu);
                setSeverityItem.setMenu(setSeverity);
                Severity[] severityArray = Severity.values();
                int n = severityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final Severity sev = severityArray[n2];
                    if (!sev.equals((Object)Severity.UNKNOWN)) {
                        MenuItem item = new MenuItem(setSeverity, 8);
                        item.setText(sev.toString().toLowerCase());
                        item.setImage(Activator.getDefault().getImageRegistry().get(String.valueOf(sev.toString()) + "-full"));
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                MenuActions.this.setSeverity(userIssues, sev);
                            }
                        });
                    }
                    ++n2;
                }
            }
        };
    }

    private void setSeverity(final List<Resource> userIssues, final Severity severity) {
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                Resource sev = IssueUtils.toSeverityResource((IssueResource)ISSUE, (Severity)severity);
                if (sev != null) {
                    for (Resource issue : userIssues) {
                        if (graph.hasStatement(issue, ISSUE.Issue_HasSeverity, sev)) continue;
                        graph.deny(issue, ISSUE.Issue_HasSeverity);
                        graph.claim(issue, ISSUE.Issue_HasSeverity, null, sev);
                    }
                } else {
                    for (Resource issue : userIssues) {
                        graph.deny(issue, ISSUE.Issue_HasSeverity);
                    }
                }
            }
        }, e -> {
            if (e != null) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        });
    }
}

