/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.handler.ElementAssortment;
import org.simantics.diagram.handler.ElementType;
import org.simantics.diagram.handler.IElementAssortment;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.modeling.ModelingResources;

public class ElementObjectAssortment
implements IElementAssortment {
    private EnumSet<ElementType> contents;
    public Set<Object> all;
    public final List<Resource> nodeList = new ArrayList<Resource>();
    public final Set<Resource> nodes = new HashSet<Resource>();
    public final Set<Resource> connections = new HashSet<Resource>();
    public final Set<EdgeResource> edges = new HashSet<EdgeResource>();
    public final Set<Resource> branchPoints = new HashSet<Resource>();
    public final Set<Resource> flags = new HashSet<Resource>();
    public final Set<Resource> references = new HashSet<Resource>();
    public final Set<Resource> monitors = new HashSet<Resource>();
    public final Set<Resource> others = new HashSet<Resource>();
    public final Set<Object> noncopyables = new HashSet<Object>();

    public ElementObjectAssortment(ReadGraph graph, Collection<Resource> elements) throws DatabaseException {
        this.all = new HashSet<Resource>(elements);
        this.contents = EnumSet.noneOf(ElementType.class);
        this.sort(graph, elements);
    }

    private void sort(ReadGraph graph, Collection<Resource> elements) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource element : elements) {
            if (graph.isInstanceOf(element, DIA.Flag)) {
                this.flags.add(element);
                this.contents.add(ElementType.Flag);
                continue;
            }
            if (graph.isInstanceOf(element, DIA.Connection)) {
                this.connections.add(element);
                this.contents.add(ElementType.Connection);
                continue;
            }
            if (graph.isInstanceOf(element, DIA.Monitor)) {
                this.monitors.add(element);
                this.contents.add(ElementType.Monitor);
                continue;
            }
            if (graph.isInstanceOf(element, MOD.ReferenceElement)) {
                this.references.add(element);
                this.contents.add(ElementType.Reference);
                continue;
            }
            if (graph.isInstanceOf(element, DIA.DefinedElement)) {
                this.nodeList.add(element);
                this.nodes.add(element);
                this.contents.add(ElementType.Node);
                continue;
            }
            if (!graph.isInstanceOf(element, DIA.Element)) continue;
            this.others.add(element);
            this.contents.add(ElementType.Other);
        }
    }

    public static ElementObjectAssortment fromElements(Set<IElement> set) {
        return new ElementObjectAssortment(new ElementAssortment(set));
    }

    public ElementObjectAssortment(ElementAssortment assortment) {
        if (assortment == null) {
            throw new IllegalArgumentException("null element assortment");
        }
        this.load(assortment);
    }

    private void load(ElementAssortment es) {
        this.contents = es.contents;
        this.all = ElementObjectAssortment.getElementObjectSet(es.all, Object.class);
        ElementObjectAssortment.getElementObjects(es.nodeList, Resource.class, this.nodeList);
        ElementObjectAssortment.getElementObjects(es.nodes, Resource.class, this.nodes);
        ElementObjectAssortment.getElementObjects(es.connections, Resource.class, this.connections);
        ElementObjectAssortment.getElementObjects(es.connections, Resource.class, this.connections);
        ElementObjectAssortment.getElementObjects(es.edges, EdgeResource.class, this.edges);
        ElementObjectAssortment.getElementObjects(es.branchPoints, Resource.class, this.branchPoints);
        ElementObjectAssortment.getElementObjects(es.flags, Resource.class, this.flags);
        ElementObjectAssortment.getElementObjects(es.references, Resource.class, this.references);
        ElementObjectAssortment.getElementObjects(es.monitors, Resource.class, this.monitors);
        ElementObjectAssortment.getElementObjects(es.others, Resource.class, this.others);
        ElementObjectAssortment.getElementObjects(es.noncopyables, Object.class, this.noncopyables);
    }

    public Set<Object> getAll() {
        return new HashSet<Object>(this.all);
    }

    @Override
    public boolean contains(ElementType et) {
        return this.contents.contains((Object)et);
    }

    @Override
    public boolean contains(Collection<ElementType> ets) {
        return this.contents.containsAll(ets);
    }

    @Override
    public boolean containsAny(Collection<ElementType> ets) {
        for (ElementType et : ets) {
            if (!this.contents.contains((Object)et)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count(ElementType et) {
        switch (et) {
            case BranchPoint: {
                return this.branchPoints.size();
            }
            case Connection: {
                return this.connections.size();
            }
            case Edge: {
                return this.edges.size();
            }
            case Flag: {
                return this.flags.size();
            }
            case Reference: {
                return this.references.size();
            }
            case Monitor: {
                return this.monitors.size();
            }
            case Node: {
                return this.nodes.size();
            }
            case Other: {
                return this.others.size();
            }
            case NonCopyable: {
                return this.noncopyables.size();
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ElementObjectAssortment:\n");
        b.append("\t CONTAINS: ");
        b.append(this.contents);
        b.append("\n");
        for (Resource resource : this.nodes) {
            b.append("\t-node " + resource + "\n");
        }
        for (Resource resource : this.connections) {
            b.append("\t-connection " + resource + "\n");
        }
        for (EdgeResource edgeResource : this.edges) {
            b.append("\t-edge " + edgeResource + "\n");
        }
        for (Resource resource : this.branchPoints) {
            b.append("\t-branch " + resource + "\n");
        }
        for (Resource resource : this.flags) {
            b.append("\t-flag " + resource + "\n");
        }
        for (Resource resource : this.references) {
            b.append("\t-reference " + resource + "\n");
        }
        for (Resource resource : this.monitors) {
            b.append("\t-monitor " + resource + "\n");
        }
        for (Object object : this.others) {
            b.append("\t-other " + object + "\n");
        }
        for (Object object : this.noncopyables) {
            b.append("\t-non-copyable " + object + "\n");
        }
        return b.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public static <T> Collection<T> getElementObjects(Collection<IElement> elements, Class<T> clazz, Collection<T> result) {
        for (IElement e : elements) {
            Object o = ElementUtils.getObject((IElement)e);
            if (!clazz.isInstance(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static <T> Set<T> getElementObjectSet(Collection<IElement> elements, Class<T> clazz) {
        HashSet result = new HashSet();
        ElementObjectAssortment.getElementObjects(elements, clazz, result);
        return result;
    }
}

