/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.nodetypes.EntityNodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ShowInBrowser
extends AbstractHandler {
    private static final String DEFAULT_BROWSER_VIEW_ID = "org.simantics.modeling.ui.browser";

    private static Read<Collection<NodeContext>> getParentsRequest(final BrowseContext bc, final NodeContext context) {
        return new UniqueRead<Collection<NodeContext>>(){

            public Collection<NodeContext> perform(ReadGraph graph) throws DatabaseException {
                return bc.getParents(graph, context);
            }
        };
    }

    private static Read<NodeType> getNodeTypeRequest(final Resource element) {
        return new UniqueRead<NodeType>(){

            public NodeType perform(ReadGraph graph) throws DatabaseException {
                return EntityNodeType.getNodeTypeFor((ReadGraph)graph, (Resource)element);
            }
        };
    }

    private static Collection<NodeContext> tryGetParents(BrowseContext bc, NodeContext context) {
        try {
            return (Collection)Simantics.getSession().syncRequest(ShowInBrowser.getParentsRequest(bc, context));
        }
        catch (DatabaseException databaseException) {
            return Collections.emptyList();
        }
    }

    private static boolean show(GraphExplorer explorer, BrowseContext browseContext, NodeContext context, Deque<NodeContext> path) {
        if (explorer.isVisible(context)) {
            return explorer.selectPath(path);
        }
        for (NodeContext parent : ShowInBrowser.tryGetParents(browseContext, context)) {
            path.addFirst(parent);
            if (ShowInBrowser.show(explorer, browseContext, parent, path)) {
                return true;
            }
            path.removeFirst();
        }
        return false;
    }

    public static Object defaultExecute(ISelection selection, String browserViewId) {
        IViewPart browser = WorkbenchUtils.findView((String)browserViewId);
        if (browser == null) {
            return null;
        }
        GraphExplorer explorer = (GraphExplorer)browser.getAdapter(GraphExplorer.class);
        BrowseContext browseContext = (BrowseContext)browser.getAdapter(BrowseContext.class);
        if (explorer == null || browseContext == null) {
            return null;
        }
        try {
            Resource element = WorkbenchSelectionUtils.getPossibleResource((Object)selection);
            WorkbenchUtils.showView((String)browserViewId, (int)2);
            NodeType nodeType = (NodeType)Simantics.getSession().syncRequest(ShowInBrowser.getNodeTypeRequest(element));
            NodeContext context = NodeContextBuilder.buildWithData((NodeContext.ConstantKey[])NodeType.KEY_SEQUENCE, (Object[])new Object[]{element, nodeType});
            LinkedList<NodeContext> path = new LinkedList<NodeContext>();
            path.add(context);
            if (ShowInBrowser.show(explorer, browseContext, context, path)) {
                WorkbenchUtils.activateView((String)browserViewId);
            }
        }
        catch (DatabaseException databaseException) {
        }
        catch (PartInitException partInitException) {}
        return null;
    }

    public static Object defaultExecute(ISelection selection) {
        return ShowInBrowser.defaultExecute(selection, DEFAULT_BROWSER_VIEW_ID);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return ShowInBrowser.defaultExecute(HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event));
    }
}

