/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.format;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class FormattingUtil {
    private int floatDigits;
    private int doubleDigits;
    private double lowLimit;
    private double highLimit;
    private DecimalFormatSymbols decimalFormatSymbols;
    private DecimalFormat flow;
    private DecimalFormat[] fmiddles;
    private DecimalFormat fhigh;
    private DecimalFormat dlow;
    private DecimalFormat[] dmiddles;
    private DecimalFormat dhigh;

    public FormattingUtil(int floatDigits, int doubleDigits) {
        this(floatDigits, doubleDigits, Locale.getDefault());
    }

    public FormattingUtil(int floatDigits, int doubleDigits, Locale locale) {
        this(floatDigits, doubleDigits, 0.01, 1000000.0, locale);
    }

    public FormattingUtil(int floatDigits, int doubleDigits, double lowLimit, double highLimit, Locale locale) {
        this.floatDigits = floatDigits;
        this.doubleDigits = doubleDigits;
        this.lowLimit = lowLimit;
        this.highLimit = highLimit;
        this.decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale != null ? locale : Locale.getDefault());
        this.initFormats();
    }

    private void initFormats() {
        this.flow = this.createLowFormat(this.floatDigits);
        double exp = Math.log10(this.highLimit);
        int formatCount = Math.max(1, (int)Math.ceil(exp));
        this.fmiddles = this.createMiddleFormats(formatCount, this.floatDigits);
        this.fhigh = this.createHighFormat(this.floatDigits);
        this.dlow = this.createLowFormat(this.doubleDigits);
        this.dmiddles = this.createMiddleFormats(formatCount, this.doubleDigits);
        this.dhigh = this.createHighFormat(this.doubleDigits);
    }

    private DecimalFormat createLowFormat(int digitCount) {
        StringBuilder fmt = new StringBuilder();
        fmt.append("0.");
        int i = 0;
        while (i < digitCount) {
            fmt.append('#');
            ++i;
        }
        return new DecimalFormat(fmt.toString(), this.decimalFormatSymbols);
    }

    private DecimalFormat createHighFormat(int digitCount) {
        StringBuilder fmt = new StringBuilder();
        fmt.append("##0");
        if (digitCount > 3) {
            fmt.append(".");
        }
        int i = 3;
        while (i < digitCount) {
            fmt.append('#');
            ++i;
        }
        fmt.append("E0");
        return new DecimalFormat(fmt.toString(), this.decimalFormatSymbols);
    }

    private DecimalFormat[] createMiddleFormats(int formatCount, int digitCount) {
        DecimalFormat[] middles = new DecimalFormat[formatCount];
        int exp10 = 0;
        while (exp10 < formatCount) {
            StringBuilder fmt = new StringBuilder();
            int digits = digitCount;
            int i = 0;
            while (i < exp10 && digits > 1) {
                fmt.append('#');
                ++i;
                --digits;
            }
            fmt.append('0');
            if (--digits > 0) {
                fmt.append('.');
            }
            while (digits > 0) {
                fmt.append('#');
                --digits;
            }
            middles[exp10] = new DecimalFormat(fmt.toString(), this.decimalFormatSymbols);
            ++exp10;
        }
        return middles;
    }

    public String engineeringFormat(Object value) {
        if (value == null) {
            return "";
        }
        Class<?> clazz = value.getClass();
        if (clazz == Double.class) {
            return this.formatNumber((Double)value);
        }
        if (clazz == Float.class) {
            return this.formatNumber(((Float)value).floatValue());
        }
        if (clazz == double[].class) {
            double[] doubles = (double[])value;
            StringBuilder b = new StringBuilder();
            b.append("[");
            boolean first = true;
            double[] dArray = doubles;
            int n = doubles.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                if (!first) {
                    b.append(",");
                }
                b.append(this.formatNumber(d));
                first = false;
                ++n2;
            }
            b.append("]");
            return b.toString();
        }
        if (clazz == float[].class) {
            float[] floats = (float[])value;
            StringBuilder b = new StringBuilder();
            b.append("[");
            boolean first = true;
            float[] fArray = floats;
            int n = floats.length;
            int n3 = 0;
            while (n3 < n) {
                float f = fArray[n3];
                if (!first) {
                    b.append(",");
                }
                b.append(this.formatNumber(f));
                first = false;
                ++n3;
            }
            b.append("]");
            return b.toString();
        }
        if (clazz == int[].class) {
            int[] ints = (int[])value;
            StringBuilder b = new StringBuilder();
            b.append("[");
            boolean first = true;
            int[] nArray = ints;
            int n = ints.length;
            int n4 = 0;
            while (n4 < n) {
                int d = nArray[n4];
                if (!first) {
                    b.append(",");
                }
                b.append(d);
                first = false;
                ++n4;
            }
            b.append("]");
            return b.toString();
        }
        if (clazz == String.class) {
            return (String)value;
        }
        return value.toString();
    }

    public String formatNumber(float v) {
        double exp;
        int expi;
        if (Float.isInfinite(v)) {
            return v == Float.POSITIVE_INFINITY ? "\u221e" : "-\u221e";
        }
        if (Float.isNaN(v)) {
            return "NaN";
        }
        float abs = Math.abs(v);
        if (abs < 1.0f && abs >= (float)this.lowLimit) {
            return this.flow.format(v);
        }
        if (abs >= 1.0f && abs < (float)this.highLimit && (expi = (int)Math.floor(exp = Math.log10(abs))) < this.fmiddles.length) {
            return this.fmiddles[expi].format(v);
        }
        return FormattingUtil.postprocess(this.fhigh.format(v));
    }

    public String formatNumber(double v) {
        double exp;
        int expi;
        if (Double.isInfinite(v)) {
            return v == Double.POSITIVE_INFINITY ? "\u221e" : "-\u221e";
        }
        if (Double.isNaN(v)) {
            return "NaN";
        }
        double abs = Math.abs(v);
        if (abs < 1.0 && abs >= this.lowLimit) {
            return this.dlow.format(v);
        }
        if (abs >= 1.0 && abs < this.highLimit && (expi = (int)Math.floor(exp = Math.log10(abs))) < this.dmiddles.length) {
            return this.dmiddles[expi].format(v);
        }
        return FormattingUtil.postprocess(this.dhigh.format(v));
    }

    private static String postprocess(String s) {
        if (s.endsWith("E0")) {
            return s.substring(0, s.length() - 2);
        }
        return s.replace('E', 'e');
    }

    public static String formatNumberLocale(Object num, int minPrecision, int maxPrecision, String languageTag) {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.forLanguageTag(languageTag));
        format.setMaximumFractionDigits(maxPrecision);
        format.setMinimumFractionDigits(minPrecision);
        if (num instanceof Number) {
            double doubleValue = ((Number)num).doubleValue();
            if (Double.isFinite(doubleValue)) {
                return format.format(doubleValue);
            }
            if (Double.isNaN(doubleValue)) {
                return "NaN";
            }
            if (Double.isInfinite(doubleValue)) {
                return "\u221e";
            }
        }
        throw new NumberFormatException("Number " + num + ", instanceOf " + num.getClass().getName());
    }

    public static void main(String[] args) {
        FormattingUtil fu = new FormattingUtil(7, 15);
        System.out.println("=== DOUBLE ===");
        System.out.println(fu.formatNumber(0.123));
        System.out.println(fu.formatNumber(-0.123));
        System.out.println(fu.formatNumber(Double.POSITIVE_INFINITY));
        System.out.println(fu.formatNumber(Double.NEGATIVE_INFINITY));
        System.out.println(fu.formatNumber(Double.NaN));
        System.out.println(fu.formatNumber(0.0f));
        System.out.println(fu.formatNumber(0.25));
        System.out.println(fu.formatNumber(0.1));
        System.out.println(fu.formatNumber(1.0f));
        System.out.println(fu.formatNumber(-0.25));
        System.out.println(fu.formatNumber(-0.1));
        System.out.println(fu.formatNumber(-1.0f));
        System.out.println(fu.formatNumber(0.9999));
        System.out.println(fu.formatNumber(0.1));
        System.out.println(fu.formatNumber(0.01));
        System.out.println(fu.formatNumber(0.004541234));
        System.out.println(fu.formatNumber(0.001));
        System.out.println(fu.formatNumber(1.0E-4));
        System.out.println(fu.formatNumber(1.0E-5));
        System.out.println(fu.formatNumber(1.0E-6));
        System.out.println(fu.formatNumber(-0.9999));
        System.out.println(fu.formatNumber(-0.1));
        System.out.println(fu.formatNumber(-0.01));
        System.out.println(fu.formatNumber(-0.001));
        System.out.println(fu.formatNumber(-1.0E-4));
        System.out.println(fu.formatNumber(1.234567891));
        System.out.println(fu.formatNumber(12.34567891));
        System.out.println(fu.formatNumber(123.4567891));
        System.out.println(fu.formatNumber(1234.567891));
        System.out.println(fu.formatNumber(12345.67891));
        System.out.println(fu.formatNumber(123456.7891));
        System.out.println(fu.formatNumber(1234567.891));
        System.out.println(fu.formatNumber(1234567.8912345679));
        System.out.println(fu.formatNumber(1.2345678912345678E7));
        System.out.println(fu.formatNumber(1.2345678912345678E8));
        System.out.println(fu.formatNumber(1.2345678912345679E9));
        System.out.println(fu.formatNumber(1.2345678912345678E10));
        System.out.println(fu.formatNumber(100.0));
        System.out.println(fu.formatNumber(100000.0));
        System.out.println(fu.formatNumber(1.0E9));
        System.out.println(fu.formatNumber(1.0E11));
        System.out.println(fu.formatNumber(1.0E13));
        System.out.println(fu.formatNumber(1000000.0));
        System.out.println(fu.formatNumber(1000000.0));
        System.out.println(fu.formatNumber(1000000.0));
        System.out.println(fu.formatNumber(1000000.0));
        System.out.println(fu.formatNumber(999999.9999999999));
        System.out.println(fu.formatNumber(999999.999999999));
        System.out.println(fu.formatNumber(999999.99999999));
        System.out.println(fu.formatNumber(999999.9999999));
        System.out.println(fu.formatNumber(999999.999999));
        System.out.println(fu.formatNumber(999999.99999));
        System.out.println(fu.formatNumber(999999.9999));
        System.out.println(fu.formatNumber(999999.999));
        System.out.println(fu.formatNumber(999999.99));
        System.out.println(fu.formatNumber(999999.9));
        System.out.println(fu.formatNumber(999999.0f));
        System.out.println("=== FLOAT ===");
        System.out.println(fu.formatNumber(0.123f));
        System.out.println(fu.formatNumber(-0.123f));
        System.out.println(fu.formatNumber(Float.POSITIVE_INFINITY));
        System.out.println(fu.formatNumber(Float.NEGATIVE_INFINITY));
        System.out.println(fu.formatNumber(Float.NaN));
        System.out.println(fu.formatNumber(0.0f));
        System.out.println(fu.formatNumber(0.25f));
        System.out.println(fu.formatNumber(0.1f));
        System.out.println(fu.formatNumber(1.0f));
        System.out.println(fu.formatNumber(-0.25f));
        System.out.println(fu.formatNumber(-0.1f));
        System.out.println(fu.formatNumber(-1.0f));
        System.out.println(fu.formatNumber(0.9999f));
        System.out.println(fu.formatNumber(0.1f));
        System.out.println(fu.formatNumber(0.01f));
        System.out.println(fu.formatNumber(0.004541234f));
        System.out.println(fu.formatNumber(0.001f));
        System.out.println(fu.formatNumber(1.0E-4f));
        System.out.println(fu.formatNumber(1.0E-5f));
        System.out.println(fu.formatNumber(1.0E-6f));
        System.out.println(fu.formatNumber(-0.9999f));
        System.out.println(fu.formatNumber(-0.1f));
        System.out.println(fu.formatNumber(-0.01f));
        System.out.println(fu.formatNumber(-0.001f));
        System.out.println(fu.formatNumber(-1.0E-4f));
        System.out.println(fu.formatNumber(1.2345679f));
        System.out.println(fu.formatNumber(12.345679f));
        System.out.println(fu.formatNumber(123.45679f));
        System.out.println(fu.formatNumber(1234.5679f));
        System.out.println(fu.formatNumber(12345.679f));
        System.out.println(fu.formatNumber(123456.79f));
        System.out.println(fu.formatNumber(1234567.9f));
        System.out.println(fu.formatNumber(1234567.9f));
        System.out.println(fu.formatNumber(1.2345679E7f));
        System.out.println(fu.formatNumber(1.2345679E8f));
        System.out.println(fu.formatNumber(1.234568E9f));
        System.out.println(fu.formatNumber(1.2345679E10f));
        System.out.println(fu.formatNumber(100.0f));
        System.out.println(fu.formatNumber(100000.0f));
        System.out.println(fu.formatNumber(1.0E9f));
        System.out.println(fu.formatNumber(1.0E11f));
        System.out.println(fu.formatNumber(1.0E13f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(1000000.0f));
        System.out.println(fu.formatNumber(999999.9f));
        System.out.println(fu.formatNumber(999999.0f));
    }
}

