/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.internal.xdot;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.graphviz.internal.xdot.DrawCommand;

public class Text
implements DrawCommand {
    double x;
    double y;
    double j;
    double w;
    String text;

    public Text(double x, double y, int j, double w, String text) {
        this.x = x;
        this.y = -y;
        this.j = j;
        this.w = w;
        this.text = text;
    }

    @Override
    public void draw(Graphics2D g) {
        double lx = this.j == -1.0 ? this.x : (this.j == 0.0 ? this.x - 0.5 * this.w : (this.j == 1.0 ? this.x - this.w : this.x));
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Rectangle2D rect = g.getFont().getStringBounds(this.text, g.getFontRenderContext());
        AffineTransform oldTransform = g.getTransform();
        g.translate(lx, this.y);
        double scale = this.w / rect.getWidth();
        g.scale(scale, scale);
        g.drawString(this.text, 0.0f, 0.0f);
        g.setTransform(oldTransform);
    }
}

