/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.drawable;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.Graphs;
import org.simantics.graphviz.drawable.Drawable;
import org.simantics.graphviz.drawable.GraphDrawable;

public class JViewer
extends JFrame {
    private static final HashMap<String, JViewer> VIEWER_MAP = new HashMap();
    private static final long serialVersionUID = 3022682167091092801L;
    Drawable drawable;
    ViewerCanvas canvas = new ViewerCanvas();
    private String windowName;

    public JViewer(Drawable _drawable) {
        this.drawable = _drawable;
        this.setTitle("Image viewer");
        this.setSize(1024, 768);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                JViewer.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                JViewer.this.repaint(0, 0, JViewer.this.getWidth(), JViewer.this.getHeight());
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                JViewer.this.requestFocus();
            }
        });
        this.getContentPane().add(this.canvas);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem saveItem = new JMenuItem(new SaveAsAction());
        JMenuItem exitItem = new JMenuItem(new ExitAction());
        menu.add(saveItem);
        menu.addSeparator();
        menu.add(exitItem);
        this.setJMenuBar(menuBar);
        this.setVisible(true);
    }

    public void updateDrawable(Drawable drawable) {
        this.drawable = drawable;
        this.canvas.fit();
        this.canvas.repaint();
    }

    public static String getExtension(File file) {
        String filename = file.getName();
        int index = filename.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return filename.substring(index + 1).toLowerCase();
    }

    public static void getOrCreateViewer(String windowName, GraphDrawable graphDrawable) {
        JViewer viewer = VIEWER_MAP.get(windowName);
        if (viewer == null) {
            viewer = new JViewer(graphDrawable);
            viewer.setTitle(windowName);
            viewer.windowName = windowName;
            VIEWER_MAP.put(windowName, viewer);
            viewer.toFront();
        } else {
            viewer.updateDrawable(graphDrawable);
            viewer.toFront();
        }
    }

    @Override
    public void dispose() {
        if (this.windowName != null) {
            VIEWER_MAP.remove(this.windowName);
        }
        super.dispose();
    }

    public class DotImageFileView
    extends FileView {
        @Override
        public String getTypeDescription(File f) {
            String ext = JViewer.getExtension(f);
            if (ext == null) {
                return null;
            }
            if (ext.equals("svg")) {
                return "Scalable Vector Graphics Image";
            }
            if (ext.equals("dot")) {
                return "DOT Image";
            }
            if (ext.equals("eps")) {
                return "Encapsulated PostScript Image";
            }
            if (ext.equals("jpg")) {
                return "JPG Image";
            }
            if (ext.equals("jpeg")) {
                return "JPG Image";
            }
            if (ext.equals("pdf")) {
                return "Portable Document Format Image";
            }
            if (ext.equals("png")) {
                return "Portable Network Graphics Image";
            }
            if (ext.equals("ps")) {
                return "PostScript Image";
            }
            return null;
        }
    }

    public class DotImageFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = JViewer.getExtension(f);
            if (ext == null) {
                return false;
            }
            if (ext.equals("svg")) {
                return true;
            }
            if (ext.equals("dot")) {
                return true;
            }
            if (ext.equals("eps")) {
                return true;
            }
            if (ext.equals("jpg")) {
                return true;
            }
            if (ext.equals("jpeg")) {
                return true;
            }
            if (ext.equals("pdf")) {
                return true;
            }
            if (ext.equals("png")) {
                return true;
            }
            return ext.equals("ps");
        }

        @Override
        public String getDescription() {
            return "Image files";
        }
    }

    public class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 5680421985865931443L;

        public ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JViewer.this.setVisible(false);
            JViewer.this.dispose();
        }
    }

    public class SaveAsAction
    extends AbstractAction {
        private static final long serialVersionUID = 4627419396805081199L;

        public SaveAsAction() {
            super("Save as");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(JViewer.this.drawable instanceof GraphDrawable)) {
                JOptionPane.showMessageDialog(JViewer.this, "File saving not supported", "Error", 0);
                return;
            }
            GraphDrawable gdraw = (GraphDrawable)JViewer.this.drawable;
            Graph graph = gdraw.getGraph();
            String algo = gdraw.getAlgorithm();
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(new DotImageFilter());
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileView(new DotImageFileView());
            int returnval = chooser.showSaveDialog(JViewer.this);
            if (returnval == 0) {
                try {
                    File file = chooser.getSelectedFile();
                    String type = JViewer.getExtension(file);
                    if (type == null) {
                        return;
                    }
                    Graphs.createImage(graph, algo, type, file);
                }
                catch (IOException err) {
                    err.printStackTrace();
                    JOptionPane.showMessageDialog(JViewer.this, "File saving failed: " + err.getMessage(), "Error", 0);
                }
            }
        }
    }

    class ViewerCanvas
    extends Canvas {
        private static final long serialVersionUID = -5330090168115281754L;
        AffineTransform transform;
        Point prev;
        Image im;

        ViewerCanvas() {
            this.setBackground(Color.WHITE);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyChar() == '1') {
                        ((ViewerCanvas)ViewerCanvas.this).JViewer.this.canvas.fit();
                        ((ViewerCanvas)ViewerCanvas.this).JViewer.this.canvas.repaint();
                    } else if (e.getKeyCode() == 27) {
                        JViewer.this.dispose();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ViewerCanvas.this.prev = e.getPoint();
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    Point cur = e.getPoint();
                    if (ViewerCanvas.this.prev == null) {
                        ViewerCanvas.this.prev = cur;
                    }
                    double deltaX = cur.getX() - ViewerCanvas.this.prev.getX();
                    double deltaY = cur.getY() - ViewerCanvas.this.prev.getY();
                    ViewerCanvas.this.transform.preConcatenate(AffineTransform.getTranslateInstance(deltaX, deltaY));
                    ViewerCanvas.this.repaint();
                    ViewerCanvas.this.prev = cur;
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (ViewerCanvas.this.transform != null) {
                        double scale = Math.exp(-0.1 * (double)e.getUnitsToScroll());
                        Point p = e.getPoint();
                        AffineTransform mod = new AffineTransform();
                        mod.translate(p.getX(), p.getY());
                        mod.scale(scale, scale);
                        mod.translate(-p.getX(), -p.getY());
                        ViewerCanvas.this.transform.preConcatenate(mod);
                        ViewerCanvas.this.repaint();
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ViewerCanvas.this.im = ViewerCanvas.this.createImage(ViewerCanvas.this.getWidth(), ViewerCanvas.this.getHeight());
                    ViewerCanvas.this.repaint();
                }
            });
        }

        private void fit() {
            Rectangle2D bounds = JViewer.this.drawable.getBounds();
            Rectangle container = this.getBounds();
            double scale = container == null ? 1.0 : Math.min(((RectangularShape)container).getWidth() / bounds.getWidth(), ((RectangularShape)container).getHeight() / bounds.getHeight());
            this.transform = new AffineTransform(scale, 0.0, 0.0, scale, ((RectangularShape)container).getX() + ((RectangularShape)container).getWidth() * 0.5 - bounds.getCenterX() * scale, ((RectangularShape)container).getY() + ((RectangularShape)container).getHeight() * 0.5 - bounds.getCenterY() * scale);
        }

        @Override
        public void paint(Graphics _g) {
            if (this.im == null) {
                this.im = this.createImage(this.getWidth(), this.getHeight());
            }
            Graphics2D g = (Graphics2D)this.im.getGraphics();
            g.clearRect(0, 0, this.im.getWidth(null), this.im.getHeight(null));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this.transform == null) {
                this.fit();
            }
            g.setTransform(this.transform);
            JViewer.this.drawable.draw(g, null);
            _g.drawImage(this.im, 0, 0, this);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }
    }
}

