/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.property;

import java.util.Collection;
import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.request.Read;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;

public class ModelPropertyTester
extends PropertyTester {
    private static final String HAS_ACTIVE_MODELS_OF_TYPE = "hasActiveModelsOfType";

    public boolean test(Object receiver, String property, final Object[] args, Object expectedValue) {
        block4: {
            Resource project;
            Session session;
            block6: {
                block5: {
                    if (!HAS_ACTIVE_MODELS_OF_TYPE.equals(property)) break block4;
                    if (args.length != 0) break block5;
                    return false;
                }
                session = Simantics.peekSession();
                project = Simantics.peekProjectResource();
                if (session == null || project == null) break block4;
                if (!DatabaseJob.inProgress()) break block6;
                return false;
            }
            try {
                return (Boolean)RequestUtil.trySyncRequest((Session)session, (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Object)false, (Read)new UniqueRead<Boolean>(){

                    public Boolean perform(ReadGraph graph) throws DatabaseException {
                        Resource type = graph.getPossibleResource(OntologyVersions.getInstance().currentVersion((String)args[0]));
                        if (type == null) {
                            return false;
                        }
                        Collection activeModels = (Collection)graph.syncRequest((Read)new ActiveModels(project));
                        for (Resource activeModel : activeModels) {
                            if (!graph.isInstanceOf(activeModel, type)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
            catch (InterruptedException | DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        return false;
    }
}

