/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions.style;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JPanel {
    private static final long serialVersionUID = -53650261362110193L;
    private static Font DEFAULT_FONT = new Font("Arial", 0, 16);
    private String sampleText;
    private JLabel text;
    private JList fontList;
    private JComboBox sizeComboBox;
    private JCheckBox boldCheckBox;
    private JCheckBox italicCheckBox;
    private String[] fonts;
    private Font originalFont;
    private Font font;

    public FontChooser(String sampleText) {
        this.sampleText = sampleText;
        JPanel textPanel = new JPanel();
        this.text = new JLabel(sampleText, 0);
        this.text.setVerticalAlignment(0);
        this.setLayout(new BorderLayout());
        textPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        textPanel.add(this.text);
        textPanel.setMinimumSize(new Dimension(100, 100));
        textPanel.setPreferredSize(new Dimension(200, 100));
        this.add((Component)textPanel, "North");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] ff = ge.getAvailableFontFamilyNames();
        this.fonts = new String[ff.length + 1];
        this.fonts[0] = "-- keep current font --";
        System.arraycopy(ff, 0, this.fonts, 1, ff.length);
        this.fontList = new JList<String>(this.fonts);
        this.fontList.setSelectionMode(0);
        this.fontList.setLayoutOrientation(0);
        this.fontList.setVisibleRowCount(-1);
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (!e.getValueIsAdjusting() && (index = FontChooser.this.fontList.getSelectedIndex()) != -1) {
                    FontChooser.this.selectFont(index);
                }
            }
        });
        this.fontList.setCellRenderer(new FontListRenderer());
        JScrollPane listScrollPane = new JScrollPane(this.fontList);
        listScrollPane.setPreferredSize(new Dimension(400, 200));
        this.add((Component)listScrollPane, "Center");
        JPanel controlPanel = new JPanel();
        this.add((Component)controlPanel, "South");
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.selectFont(FontChooser.this.fontList.getSelectedIndex());
            }
        };
        Integer[] sizes = new Integer[]{4, 6, 7, 8, 9, 10, 11, 12, 14, 18, 20, 22, 24, 36, 40, 48, 56, 64, 72, 144};
        this.sizeComboBox = new JComboBox<Integer>(sizes);
        this.sizeComboBox.addActionListener(listener);
        this.sizeComboBox.setSelectedIndex(7);
        controlPanel.add(new JLabel("Size: "));
        controlPanel.add(this.sizeComboBox);
        this.boldCheckBox = new JCheckBox("Bold");
        this.boldCheckBox.addActionListener(listener);
        controlPanel.add(this.boldCheckBox);
        this.italicCheckBox = new JCheckBox("Italic");
        this.italicCheckBox.addActionListener(listener);
        controlPanel.add(this.italicCheckBox);
        this.fontList.setSelectedIndex(0);
    }

    private void selectFont(int index) {
        if (index < 0) {
            return;
        }
        String name = this.fonts[index];
        Integer size = (Integer)this.sizeComboBox.getSelectedItem();
        int style = 0;
        if (this.boldCheckBox.isSelected()) {
            style |= 1;
        }
        if (this.italicCheckBox.isSelected()) {
            style |= 2;
        }
        Font original = this.originalFont != null ? this.originalFont : DEFAULT_FONT;
        Font f = index == 0 ? original.deriveFont(style, size.intValue()) : new Font(name, style, size);
        this.font = !f.equals(original) ? f : null;
        this.text.setText(this.sampleText);
        this.text.setFont(f);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public void setCurrentFont(Font font) {
        int index = -1;
        int i = 0;
        while (i < this.fonts.length) {
            if (this.fonts[i].equals(font.getFamily())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        this.fontList.setSelectedIndex(index);
        this.fontList.scrollRectToVisible(this.fontList.getCellBounds(index, index));
        this.boldCheckBox.setSelected((font.getStyle() & 1) > 0);
        this.italicCheckBox.setSelected((font.getStyle() & 2) > 0);
        this.sizeComboBox.setSelectedItem(font.getSize());
        this.originalFont = font;
        this.selectFont(index);
    }

    public class FontListRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1237633327794383545L;

        public FontListRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String text = (String)value;
            this.setText(text);
            return this;
        }
    }
}

