/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledIcon;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.Pair;

public class BundleIcon
implements ModelledIcon {
    private final Resource configuration;
    private Pair<String, String> location;

    public BundleIcon(ReadGraph graph, Resource configuration) throws DatabaseException {
        this.configuration = configuration;
        this.location = (Pair)graph.syncRequest((Read)new Location(configuration));
    }

    @Override
    public ImageDescriptor create() throws DatabaseException {
        Pair bundleAndPath = (Pair)Simantics.getSession().syncRequest((Read)new Location(this.configuration));
        if (bundleAndPath == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)((String)bundleAndPath.first));
        if (bundle == null) {
            return null;
        }
        URL url = bundle.getEntry((String)bundleAndPath.second);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.location + "]";
    }

    static class Location
    implements Read<Pair<String, String>> {
        Resource configuration;

        public Location(Resource configuration) {
            this.configuration = configuration;
        }

        public Pair<String, String> perform(ReadGraph graph) throws DatabaseException {
            BrowsingResource BRO = BrowsingResource.getInstance((ReadGraph)graph);
            String bundle = (String)graph.getPossibleRelatedValue(this.configuration, BRO.BundleIcon_Bundle);
            if (bundle == null) {
                return null;
            }
            String path = (String)graph.getPossibleRelatedValue(this.configuration, BRO.BundleIcon_Path);
            if (path == null) {
                return null;
            }
            return Pair.make((Object)bundle, (Object)path);
        }
    }
}

