/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.simantics.scenegraph.ILookupService;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.G2DRepaintManager;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventDelegator;
import org.simantics.scenegraph.g2d.events.INodeEventHandlerProvider;
import org.simantics.scenegraph.g2d.events.NodeEventHandler;

public class G2DSceneGraph
extends G2DParentNode
implements ILookupService,
INodeEventHandlerProvider {
    private static final long serialVersionUID = -7066146333849901429L;
    public static final String IGNORE_FOCUS = "ignoreFocus";
    protected transient Container rootPane = null;
    private final transient Object treeLock = new Object();
    private HashMap<Object, Integer> pending = new HashMap();
    private HashMap<String, Object> globalProperties = new HashMap();
    protected transient Set<INode> nodesToRemoveSet = new HashSet<INode>();
    protected Deque<INode> nodesToRemove = new ArrayDeque<INode>();
    private transient EventDelegator eventDelegator = new EventDelegator(this);
    private transient NodeEventHandler eventHandler = new NodeEventHandler(this);
    private transient IG2DNode focusNode;
    private transient G2DRepaintManager repaintManager;
    private final Object lookupLock = new Object();
    private final Map<String, INode> toNode = new HashMap<String, INode>();
    private final Map<INode, String> toId = new HashMap<INode, String>();
    transient Logger logger = Logger.getLogger(this.getClass().getName());

    public EventDelegator getEventDelegator() {
        return this.eventDelegator;
    }

    @Override
    public NodeEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public void setFocusNode(IG2DNode focusNode) {
        this.focusNode = focusNode;
    }

    @Override
    public IG2DNode getFocusNode() {
        return this.focusNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics2D g2d) {
        this.refresh();
        Container rootPane = this.getRootPane();
        if (rootPane != null) {
            g2d.setRenderingHint(G2DRenderingHints.KEY_COMPONENT, rootPane);
        }
        Object object = this.treeLock;
        synchronized (object) {
            super.render(g2d);
        }
    }

    @Override
    public void refresh() {
        this.performCleanup();
        super.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable r) {
        Object object = this.treeLock;
        synchronized (object) {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootPane(JComponent rootPane) {
        Class<RepaintManager> clazz = RepaintManager.class;
        synchronized (RepaintManager.class) {
            RepaintManager old = RepaintManager.currentManager(rootPane);
            old = this.findProperRepaintManager(old);
            this.repaintManager = new G2DRepaintManager(rootPane.getClass(), old);
            RepaintManager.setCurrentManager(this.repaintManager);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.rootPane = rootPane;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootPane(Container rootPane, Component paintContext) {
        Class<RepaintManager> clazz = RepaintManager.class;
        synchronized (RepaintManager.class) {
            RepaintManager old = RepaintManager.currentManager(paintContext);
            old = this.findProperRepaintManager(old);
            this.repaintManager = new G2DRepaintManager(paintContext.getClass(), old);
            RepaintManager.setCurrentManager(this.repaintManager);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.rootPane = rootPane;
            return;
        }
    }

    private RepaintManager findProperRepaintManager(RepaintManager old) {
        while (old instanceof G2DRepaintManager) {
            G2DRepaintManager g2drm = (G2DRepaintManager)old;
            old = g2drm.getDelegate();
        }
        return old;
    }

    public G2DRepaintManager getRepaintManager() {
        return this.repaintManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncRemoveNode(INode node) {
        Deque<INode> deque = this.nodesToRemove;
        synchronized (deque) {
            if (this.nodesToRemoveSet.add(node)) {
                this.nodesToRemove.add(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCleanup() {
        Deque<INode> deque = this.nodesToRemove;
        synchronized (deque) {
            while (this.nodesToRemove.size() > 0) {
                INode node = this.nodesToRemove.removeFirst();
                ParentNode<?> parent = node.getParent();
                if (parent == null) continue;
                parent.removeNode(node);
            }
            if (!this.nodesToRemoveSet.isEmpty()) {
                this.nodesToRemoveSet.clear();
            }
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.nodesToRemove.clear();
        this.nodesToRemove = null;
        this.nodesToRemoveSet.clear();
        this.nodesToRemoveSet = null;
        this.eventHandler.dispose();
        this.eventHandler = null;
        this.eventDelegator.dispose();
        this.eventDelegator = null;
    }

    public Container getRootPane() {
        return this.rootPane;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [root pane=" + this.rootPane + "]";
    }

    @Override
    public ParentNode<?> getRootNode() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INode map(String id, INode node) {
        String oldId;
        INode oldNode;
        if (id == null) {
            throw new NullPointerException("null id");
        }
        if (node == null) {
            throw new NullPointerException("null node");
        }
        Object object = this.lookupLock;
        synchronized (object) {
            INode removedNode;
            String removedId;
            oldNode = this.toNode.put(id, node);
            oldId = this.toId.put(node, id);
            if (oldNode != null && !oldNode.equals(node) && !id.equals(removedId = this.toId.remove(oldNode))) {
                this.toNode.remove(removedId);
            }
            if (oldId != null && !oldId.equals(id) && (removedNode = this.toNode.remove(oldId)) != node) {
                this.toId.remove(removedNode);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.fine("map(" + id + ", " + node + ")");
        }
        if ((oldNode != null || oldId != null) && this.logger.isLoggable(Level.FINE)) {
            this.logger.info("replaced mappings for ID " + oldId + " and node " + oldNode);
        }
        return oldNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INode unmap(String id) {
        String mappedId;
        INode node;
        Object object = this.lookupLock;
        synchronized (object) {
            block6: {
                node = this.toNode.remove(id);
                if (node != null) break block6;
                return null;
            }
            mappedId = this.toId.remove(node);
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.fine("unmap(" + id + "): " + node);
        }
        if (mappedId != null && !mappedId.equals(id) && this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "mapping was out-of-sync: " + id + " => " + node + " & " + mappedId + " => " + node, new Exception("trace"));
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String unmap(INode node) {
        INode mappedNode;
        String id;
        Object object = this.lookupLock;
        synchronized (object) {
            block6: {
                id = this.toId.remove(node);
                if (node != null) break block6;
                return null;
            }
            mappedNode = this.toNode.remove(id);
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.fine("unmap(" + node + "): " + id);
        }
        if (mappedNode != null && node != mappedNode && this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "mapping was out-of-sync: " + node + " => " + id + " & " + id + " => " + mappedNode, new Exception("trace"));
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INode lookupNode(String id) {
        Object object = this.lookupLock;
        synchronized (object) {
            return this.toNode.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupId(INode node) {
        Object object = this.lookupLock;
        synchronized (object) {
            return this.toId.get(node);
        }
    }

    public boolean isPending() {
        return !this.pending.isEmpty();
    }

    public synchronized void increasePending(Object object) {
        Integer ref = this.pending.get(object);
        if (ref == null) {
            this.pending.put(object, 1);
        } else {
            this.pending.put(object, ref + 1);
        }
    }

    public synchronized void setPending(Object object) {
        this.pending.put(object, 1);
    }

    public synchronized void clearPending(Object object) {
        this.pending.remove(object);
    }

    public synchronized void decreasePending(Object object) {
        Integer ref = this.pending.get(object);
        if (ref == null) {
            return;
        }
        if (ref > 1) {
            this.pending.put(object, ref - 1);
        } else if (ref == 1) {
            this.pending.remove(object);
        } else {
            return;
        }
    }

    public synchronized void setGlobalProperty(String key, Object value) {
        this.globalProperties.put(key, value);
    }

    public synchronized <T> T getGlobalProperty(String key, T defaultValue) {
        Object t = this.globalProperties.get(key);
        if (t == null) {
            return defaultValue;
        }
        return (T)t;
    }
}

