/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.validators;

import org.eclipse.jface.dialogs.IInputValidator;

public class MultiValidator
implements IInputValidator {
    private final IInputValidator[] validators;
    private final AcceptType acceptType;

    public MultiValidator(IInputValidator[] validators, AcceptType acceptType) {
        this.acceptType = acceptType;
        this.validators = new IInputValidator[validators.length];
        int i = 0;
        while (i < validators.length) {
            this.validators[i] = validators[i];
            ++i;
        }
    }

    public String isValid(String newText) {
        if (this.acceptType == AcceptType.ALL_MUST_PASS) {
            int i = 0;
            while (i < this.validators.length) {
                String result = this.validators[i].isValid(newText);
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return null;
        }
        if (this.acceptType == AcceptType.ONE_MUST_PASS) {
            String error = null;
            int i = 0;
            while (i < this.validators.length) {
                String result = this.validators[i].isValid(newText);
                if (result == null) {
                    return null;
                }
                error = result;
                ++i;
            }
            return error;
        }
        return null;
    }

    public static enum AcceptType {
        ALL_MUST_PASS,
        ONE_MUST_PASS;

    }
}

