/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.internal.awt;

import java.awt.EventQueue;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.utils.ui.internal.awt.AwtFocusHandler;

public class SwtFocusHandler
implements FocusListener,
KeyListener {
    private Composite composite;
    private final Display display;
    private AwtFocusHandler awtHandler;

    public SwtFocusHandler(Composite composite) {
        assert (composite != null);
        assert (Display.getCurrent() != null);
        this.composite = composite;
        this.display = composite.getDisplay();
        composite.addFocusListener((FocusListener)this);
        composite.addKeyListener((KeyListener)this);
    }

    public void setAwtHandler(AwtFocusHandler handler) {
        assert (handler != null);
        assert (this.awtHandler == null);
        assert (this.composite != null);
        assert (Display.getCurrent() != null);
        this.awtHandler = handler;
        final ControlAdapter controlAdapter = new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                if (!$assertionsDisabled && SwtFocusHandler.this.awtHandler == null) {
                    throw new AssertionError();
                }
                SwtFocusHandler.this.awtHandler.postHidePopups();
            }
        };
        final Shell shell = this.composite.getShell();
        shell.addControlListener((ControlListener)controlAdapter);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                shell.removeControlListener((ControlListener)controlAdapter);
                SwtFocusHandler.this.awtHandler.dispose();
                SwtFocusHandler.this.awtHandler = null;
                SwtFocusHandler.this.composite = null;
            }
        });
    }

    void gainFocusNext() {
        this.traverse(16);
    }

    void gainFocusPrevious() {
        this.traverse(8);
    }

    private void traverse(final int traversal) {
        if (this.composite == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SwtFocusHandler.this.composite.traverse(traversal);
            }
        };
        this.display.asyncExec(r);
    }

    public void focusGained(FocusEvent e) {
        assert (this.awtHandler != null);
        assert (Display.getCurrent() != null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SwtFocusHandler.this.awtHandler != null) {
                    SwtFocusHandler.this.awtHandler.gainFocus();
                }
            }
        });
    }

    public void focusLost(FocusEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        assert (Display.getCurrent() != null);
        int cfr_ignored_0 = e.keyCode;
    }

    public void keyReleased(KeyEvent e) {
    }
}

