/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class ColorImageDescriptor
extends ImageDescriptor {
    static final PaletteData PALETTEDATA = new PaletteData(0xFF0000, 65280, 255);
    int width;
    int height;
    int c;
    boolean selected;

    public ColorImageDescriptor(int red, int green, int blue, int width, int height, boolean selected) {
        this.c = red << 16 | green << 8 | blue;
        this.width = width;
        this.height = height;
        this.selected = selected;
    }

    public ImageData getImageData() {
        ImageData id = new ImageData(this.width, this.height, 24, PALETTEDATA);
        int cx = this.width / 2;
        int cy = this.height / 2;
        int dst = this.height * this.width / 23;
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                int dist;
                boolean border;
                int color = this.c;
                boolean bl = border = x == 0 || x == this.width - 1 || y == 0 || y == this.height - 1;
                if (border) {
                    color = 0;
                }
                if (this.selected && (dist = (x - cx) * (x - cx) + (y - cy) * (y - cy)) < dst) {
                    color = 0xCCCCCC;
                }
                id.setPixel(x, y, color);
                ++y;
            }
            ++x;
        }
        return id;
    }

    public int hashCode() {
        return this.c + 7 * this.width + 13 * this.height + (this.selected ? 234234 : 4235);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorImageDescriptor)) {
            return false;
        }
        ColorImageDescriptor other = (ColorImageDescriptor)((Object)obj);
        if (other.width != this.width) {
            return false;
        }
        if (other.height != this.height) {
            return false;
        }
        if (other.c != this.c) {
            return false;
        }
        return other.selected == this.selected;
    }
}

