/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import gnu.trove.map.hash.THashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.SafeName;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.indexing.IndexPolicy;
import org.simantics.db.indexing.IndexSchema;
import org.simantics.db.indexing.IndexUtils;
import org.simantics.db.indexing.Queries;
import org.simantics.db.indexing.exception.IndexCorruptedException;
import org.simantics.db.indexing.exception.IndexingException;
import org.simantics.db.indexing.internal.IndexingJob;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.IndexException;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;

public abstract class IndexedRelationsSearcherBase {
    private State state = State.READY;
    private Throwable exception;
    public static final FieldType STRING_TYPE = new FieldType();
    final RequestProcessor session;
    final Resource relation;
    final IndexSchema schema;
    Resource input;
    Path indexPath;
    Directory directory;
    IndexReader reader;
    IndexWriter writer;
    IndexSearcher searcher;
    private static final int INDEXING_THREAD_COUNT = 2;

    static {
        STRING_TYPE.setIndexed(true);
        STRING_TYPE.setStored(true);
        STRING_TYPE.setTokenized(true);
        STRING_TYPE.freeze();
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setProblem(Throwable t) {
        if (t != null) {
            this.getLogger().error("Setting problem for {} and previous state {}", new Object[]{this, this.state, t});
        }
        this.state = State.PROBLEM;
        this.exception = t;
    }

    public void setNone() {
        this.state = State.NONE;
    }

    public void setReady() {
        this.state = State.READY;
    }

    public State state() {
        return this.state;
    }

    protected boolean checkState(State state) {
        return this.state == state;
    }

    protected void assertState(State state) throws IndexException {
        State s = this.state;
        if (s != state) {
            throw new IndexException("Illegal index searcher state, expected " + state.name() + " but state was " + s.name());
        }
    }

    public void changeState(IProgressMonitor monitor, Session session, State state) {
        this.changeState(monitor, session, state, 0);
    }

    protected void changeState(IProgressMonitor monitor, Session session, State state, int depth) {
        block26: {
            boolean success;
            block25: {
                if (this.state == state) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Trying to change state {} to the same as previous state {} in depth {} with {}", new Object[]{state, this.state, depth, this});
                    }
                    return;
                }
                if (IndexPolicy.TRACE_INDEX_MANAGEMENT) {
                    System.err.println("Index state " + this.state.name() + " => " + state.name() + " " + this);
                }
                if (State.PROBLEM == this.state && depth > 0) {
                    this.getLogger().info("Try to exit problem state for {} and state {}", (Object)this, (Object)state);
                    Throwable t = this.bestEffortClear(monitor, session);
                    if (t != null) {
                        this.getLogger().error("Best effort clear has failed for state {} and this {}", new Object[]{state, this, t});
                        this.exception = t;
                        return;
                    }
                    this.state = State.NONE;
                    this.getLogger().info("Managed to get into initial state {}", (Object)this.state);
                    return;
                }
                if (State.NONE == this.state && State.READ == state) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Cannot move into read from no index in {} with state {}", (Object)this, (Object)state);
                    }
                    return;
                }
                if (State.NONE == this.state && State.WRITE == state) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Cannot move into write from no index in {} with state {}", (Object)this, (Object)state);
                    }
                    return;
                }
                success = false;
                try {
                    try {
                        boolean forWriting;
                        if (this.searcher != null) {
                            this.searcher = null;
                        }
                        if (this.reader != null) {
                            this.reader.close();
                            this.reader = null;
                        }
                        this.closeWriter(this.writer);
                        this.directory = null;
                        success = true;
                        if (State.READ != state && State.WRITE != state) break block25;
                        success = false;
                        boolean bl = forWriting = State.WRITE == state;
                        if (this.directory != null) {
                            throw new IllegalStateException(String.valueOf(this.getDescriptor()) + "Index already loaded");
                        }
                        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        mon.beginTask("Loading index", 100);
                        if (IndexPolicy.TRACE_INDEX_LOAD) {
                            System.out.println(String.valueOf(this.getDescriptor()) + "Loading Lucene index from " + this.indexPath + " for " + (forWriting ? "writing" : "reading"));
                        }
                        long start = System.nanoTime();
                        this.directory = this.getDirectory(session);
                        if (forWriting) {
                            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_4_9, (Analyzer)Queries.getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.APPEND);
                            try {
                                this.writer = new IndexWriter(this.directory, config);
                            }
                            catch (IndexNotFoundException indexNotFoundException) {
                                this.writer = new IndexWriter(this.directory, config.setOpenMode(IndexWriterConfig.OpenMode.CREATE));
                                this.writer.commit();
                            }
                            this.reader = DirectoryReader.open((Directory)this.directory);
                            this.searcher = new IndexSearcher(this.reader);
                        } else {
                            this.reader = DirectoryReader.open((Directory)this.directory);
                            this.searcher = new IndexSearcher(this.reader);
                        }
                        long end = System.nanoTime();
                        mon.worked(100);
                        if (IndexPolicy.PERF_INDEX_LOAD) {
                            double time = (double)(end - start) * 1.0E-6;
                            System.out.println(String.valueOf(this.getDescriptor()) + "Loaded Lucene index from " + this.indexPath + " for " + (forWriting ? "writing" : "reading") + " in " + time + " ms");
                        }
                        success = true;
                    }
                    catch (Throwable t) {
                        this.setProblem(t);
                        if (!success) {
                            this.state = State.PROBLEM;
                            this.changeState(monitor, session, State.NONE, depth + 1);
                            return;
                        }
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    if (!success) {
                        this.state = State.PROBLEM;
                        this.changeState(monitor, session, State.NONE, depth + 1);
                        return;
                    }
                    throw throwable;
                }
            }
            if (!success) {
                this.state = State.PROBLEM;
                this.changeState(monitor, session, State.NONE, depth + 1);
                return;
            }
        }
        this.state = state;
    }

    protected static Field makeField(String fieldName, String fieldClass) throws IndexingException {
        switch (fieldClass) {
            case "Long": {
                return new LongField(fieldName, 0L, Field.Store.YES);
            }
            case "String": {
                return new Field(fieldName, "", STRING_TYPE);
            }
            case "Text": {
                return new TextField(fieldName, "", Field.Store.YES);
            }
        }
        throw new IndexingException("Can only index Long, String and Text fields, encountered field type " + fieldClass);
    }

    protected static Field[] makeFieldsForRelation(GenericRelation r, int boundLength, Document document) throws DatabaseException {
        Pair[] fields = r.getFields();
        Field[] fs = new Field[Math.max(0, fields.length - boundLength)];
        int i = boundLength;
        while (i < fields.length) {
            Field f;
            fs[i - boundLength] = f = IndexedRelationsSearcherBase.makeField((String)fields[i].first, (String)fields[i].second);
            if (document != null) {
                document.add((IndexableField)f);
            }
            ++i;
        }
        return fs;
    }

    void insertIndex(IProgressMonitor monitor, GenericRelation r, int boundLength, Collection<Object[]> documentsData) throws CorruptIndexException, IOException, DatabaseException {
        this.assertAccessOpen(true);
        if (IndexPolicy.TRACE_INDEX_UPDATE) {
            System.out.println(String.valueOf(this.getDescriptor()) + "Inserting " + documentsData.size() + " documents into index at " + this.indexPath);
        }
        long start = 0L;
        long end = 0L;
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            start = System.nanoTime();
        }
        Document document = new Document();
        Field[] fs = IndexedRelationsSearcherBase.makeFieldsForRelation(r, boundLength, document);
        for (Object[] documentData : documentsData) {
            if (this.setFields(fs, documentData) == null) continue;
            if (IndexPolicy.TRACE_INDEX_UPDATE) {
                System.out.println(String.valueOf(this.getDescriptor()) + "Inserting document " + document);
            }
            this.writer.addDocument((Iterable)document);
        }
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            end = System.nanoTime();
            double ms = (double)(end - start) * 1.0E-6;
            System.out.println(String.valueOf(this.getDescriptor()) + "Inserted " + documentsData.size() + " documents into index at " + this.indexPath + " in " + ms + " ms");
        }
    }

    void removeIndex(IProgressMonitor monitor, GenericRelation r, RequestProcessor processor, String key, Collection<Object> keyValues) throws DatabaseException, CorruptIndexException, IOException {
        this.assertAccessOpen(true);
        if (IndexPolicy.TRACE_INDEX_UPDATE) {
            System.out.println(String.valueOf(this.getDescriptor()) + "Removing " + keyValues.size() + " documents from index at " + this.indexPath);
        }
        long start = 0L;
        long end = 0L;
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            start = System.nanoTime();
        }
        for (Object keyValue : keyValues) {
            Term removedTerm = null;
            if (keyValue instanceof Long) {
                removedTerm = IndexUtils.longTerm(key, (Long)keyValue);
            } else {
                if (!(keyValue instanceof String)) continue;
                removedTerm = new Term(key, (String)keyValue);
            }
            if (IndexPolicy.TRACE_INDEX_UPDATE) {
                System.out.println(String.valueOf(this.getDescriptor()) + "Removing document with key " + removedTerm);
            }
            this.writer.deleteDocuments(new Term[]{removedTerm});
        }
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            end = System.nanoTime();
            double ms = (double)(end - start) * 1.0E-6;
            System.out.println(String.valueOf(this.getDescriptor()) + "Removed " + keyValues.size() + " documents from index at " + this.indexPath + " in " + ms + " ms");
        }
    }

    void removeIndex(IProgressMonitor monitor) throws DatabaseException, CorruptIndexException, IOException {
        this.assertAccessOpen(true);
        long start = 0L;
        long end = 0L;
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            start = System.nanoTime();
        }
        this.writer.deleteAll();
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            end = System.nanoTime();
            double ms = (double)(end - start) * 1.0E-6;
            System.out.println(String.valueOf(this.getDescriptor()) + "Removed all documents from index at " + this.indexPath + " in " + ms + " ms");
        }
    }

    boolean replaceIndex(IProgressMonitor monitor, String key, Collection<Object> keyValues, GenericRelation r, int boundLength, Collection<Object[]> documentsData) throws CorruptIndexException, IOException, DatabaseException {
        boolean didReplace = false;
        this.assertAccessOpen(true);
        if (keyValues.size() != documentsData.size()) {
            throw new IllegalArgumentException("keyValues size does not match documents data size, " + keyValues.size() + " <> " + documentsData.size());
        }
        if (IndexPolicy.TRACE_INDEX_UPDATE) {
            System.out.println(String.valueOf(this.getDescriptor()) + "Replacing " + keyValues.size() + " documents from index at " + this.indexPath);
        }
        long start = 0L;
        long end = 0L;
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            start = System.nanoTime();
        }
        Iterator<Object> keyIt = keyValues.iterator();
        Iterator<Object[]> documentDataIt = documentsData.iterator();
        Document document = new Document();
        Field[] fs = IndexedRelationsSearcherBase.makeFieldsForRelation(r, boundLength, document);
        while (keyIt.hasNext()) {
            Object keyValue = keyIt.next();
            Object[] documentData = documentDataIt.next();
            Term removedTerm = null;
            if (keyValue instanceof Long) {
                removedTerm = IndexUtils.longTerm(key, (Long)keyValue);
            } else if (keyValue instanceof String) {
                removedTerm = new Term(key, (String)keyValue);
            } else {
                System.err.println("[" + this.getClass().getSimpleName() + "] Unrecognized document key to remove '" + keyValue + "', only " + String.class + " and " + Resource.class + " are supported.");
                continue;
            }
            if (this.setFields(fs, documentData) == null) continue;
            if (IndexPolicy.TRACE_INDEX_UPDATE) {
                System.out.println(String.valueOf(this.getDescriptor()) + "Replacing document with key " + removedTerm + " with " + document);
            }
            boolean done = false;
            if (this.requireChangeInfoOnReplace()) {
                TopDocs exist = this.searcher.search((Query)new TermQuery(removedTerm), null, 2);
                if (exist.scoreDocs.length == 1 && this.requireChangeInfoOnReplace()) {
                    Document doc = this.reader.document(exist.scoreDocs[0].doc);
                    if (!this.areSame(doc, document)) {
                        this.writer.deleteDocuments(new Term[]{removedTerm});
                        this.writer.addDocument((Iterable)document);
                        didReplace |= true;
                        if (IndexPolicy.TRACE_INDEX_UPDATE) {
                            System.out.println("-replaced single existing");
                        }
                    } else if (IndexPolicy.TRACE_INDEX_UPDATE) {
                        System.out.println("-was actually same than single existing");
                    }
                    done = true;
                }
            }
            if (done) continue;
            this.writer.deleteDocuments(new Term[]{removedTerm});
            this.writer.addDocument((Iterable)document);
            didReplace |= true;
            if (!IndexPolicy.TRACE_INDEX_UPDATE) continue;
            System.out.println("-had many or none - removed all existing");
        }
        if (IndexPolicy.PERF_INDEX_UPDATE) {
            end = System.nanoTime();
            double ms = (double)(end - start) * 1.0E-6;
            System.out.println(String.valueOf(this.getDescriptor()) + "Replaced " + keyValues.size() + " documents from index at " + this.indexPath + " in " + ms + " ms");
        }
        return didReplace;
    }

    protected boolean requireChangeInfoOnReplace() {
        return true;
    }

    private boolean areSame(Document d1, Document d2) {
        List fs1 = d1.getFields();
        List fs2 = d2.getFields();
        if (fs1.size() != fs2.size()) {
            return false;
        }
        int i = 0;
        while (i < fs1.size()) {
            IndexableField f1 = (IndexableField)fs1.get(i);
            IndexableField f2 = (IndexableField)fs2.get(i);
            String s1 = f1.stringValue();
            String s2 = f2.stringValue();
            if (IndexPolicy.TRACE_INDEX_UPDATE) {
                System.err.println("areSame " + s1 + " vs. " + s2);
            }
            if (!ObjectUtils.objectEquals((Object)s1, (Object)s2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    IndexedRelationsSearcherBase(RequestProcessor session, Resource relation, Resource input) {
        this.session = session;
        this.relation = relation;
        this.input = input;
        this.indexPath = IndexedRelationsSearcherBase.getIndexDirectory(session.getSession(), relation, input);
        this.state = this.isIndexAvailable() ? State.READY : State.NONE;
        this.schema = IndexSchema.readFromRelation(session, relation);
    }

    Directory getDirectory(Session session) throws IOException {
        return FSDirectory.open((File)this.indexPath.toFile());
    }

    abstract String getDescriptor();

    boolean startAccess(IProgressMonitor monitor, Session session, boolean forWriting) {
        if (forWriting) {
            this.changeState(monitor, session, State.WRITE);
            return this.checkState(State.WRITE);
        }
        this.changeState(monitor, session, State.READ);
        return this.checkState(State.READ);
    }

    boolean hasAccess(boolean forWriting) {
        if (forWriting) {
            return this.checkState(State.WRITE);
        }
        return this.checkState(State.WRITE) || this.checkState(State.READ);
    }

    void assertAccessOpen(boolean forWriting) {
        if (forWriting) {
            if (!this.checkState(State.WRITE)) {
                throw new IllegalStateException("index not opened for writing (directory=" + this.directory + ", reader=" + this.reader + ")");
            }
            if (!this.checkState(State.WRITE) && !this.checkState(State.READ)) {
                throw new IllegalStateException("index not opened for reading (directory=" + this.directory + ", writer=" + this.writer + ")");
            }
        }
    }

    void closeWriter(IndexWriter writer) throws CorruptIndexException, IOException {
        if (writer == null) {
            return;
        }
        try {
            writer.close(false);
        }
        catch (OutOfMemoryError e) {
            writer.close();
            throw e;
        }
    }

    public static String getPattern(GenericRelation relation, int boundCount) {
        String result = "";
        int i = 0;
        while (i < boundCount) {
            result = String.valueOf(result) + "b";
            ++i;
        }
        i = 0;
        while (i < relation.getFields().length - boundCount) {
            result = String.valueOf(result) + "f";
            ++i;
        }
        return result;
    }

    void initializeIndex(IProgressMonitor monitor, ReadGraph graph, Object[] bound, boolean overwrite) throws IOException, DatabaseException {
        IndexingJob.jobifyIfPossible(monitor, "Reindexing " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)this.input), (DbConsumer<IProgressMonitor>)((DbConsumer)mon -> {
            try {
                GenericRelation r = (GenericRelation)graph.adapt(this.relation, GenericRelation.class);
                if (r == null) {
                    throw new IndexingException("Given resource " + this.relation + "could not be adapted to GenericRelation.");
                }
                GenericRelation selection = r.select(IndexedRelationsSearcherBase.getPattern(r, bound.length), bound);
                List results = selection.realize(graph);
                this.initializeIndexImpl(new CompletableFuture(), (IProgressMonitor)mon, r, results, bound, overwrite);
            }
            catch (IOException e) {
                this.getLogger().error("Index is in problematic state! {}", (Object)this, (Object)e);
                throw new IndexingException(e);
            }
        }));
    }

    void initializeIndexImpl(CompletableFuture<?> result, IProgressMonitor monitor, GenericRelation r, List<Object[]> results, Object[] bound, boolean overwrite) throws IOException {
        try {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (IndexPolicy.TRACE_INDEX_INIT) {
                System.out.println(String.valueOf(this.getDescriptor()) + "Initializing index at " + this.indexPath + " (overwrite = " + overwrite + ")");
            }
            mon.beginTask("Initializing Index", 100);
            if (overwrite && Files.exists(this.indexPath, new LinkOption[0])) {
                mon.subTask("Erasing previous index");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Erasing previous index {}", (Object)this.indexPath.toAbsolutePath());
                }
                FileUtils.emptyDirectory((Path)this.indexPath);
            }
            AtomicReference<FSDirectory> directory = new AtomicReference<FSDirectory>();
            AtomicReference<IndexWriter> writer = new AtomicReference<IndexWriter>();
            try {
                mon.subTask("Start index write");
                Files.createDirectories(this.indexPath, new FileAttribute[0]);
                directory.set(FSDirectory.open((File)this.indexPath.toFile()));
                IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_4_9, (Analyzer)Queries.getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                writer.set(new IndexWriter((Directory)directory.get(), conf));
                mon.worked(5);
                long realizeStart = 0L;
                if (IndexPolicy.PERF_INDEX_INIT) {
                    realizeStart = System.nanoTime();
                }
                mon.subTask("Calculating indexed content");
                mon.worked(5);
                mon.worked(40);
                if (IndexPolicy.PERF_INDEX_INIT) {
                    System.out.println(String.valueOf(this.getDescriptor()) + "Realized index with " + results.size() + " entries at " + this.indexPath + " in " + 1.0E-9 * (double)(System.nanoTime() - realizeStart) + " seconds.");
                }
                if (IndexPolicy.TRACE_INDEX_INIT) {
                    System.out.println(String.valueOf(this.getDescriptor()) + "Indexed relation " + r + " produced " + results.size() + " results");
                }
                long start = IndexPolicy.PERF_INDEX_INIT ? System.nanoTime() : 0L;
                mon.subTask("Indexing content");
                Semaphore s = new Semaphore(0);
                mon.setWorkRemaining(results.size());
                int i = 0;
                while (i < 2) {
                    int startIndex = i++;
                    ThreadUtils.getBlockingWorkExecutor().submit(() -> {
                        try {
                            try {
                                Document document = new Document();
                                Field[] fs = IndexedRelationsSearcherBase.makeFieldsForRelation(r, bound.length, document);
                                int index = startIndex;
                                while (index < results.size()) {
                                    if (this.setFields(fs, (Object[])results.get(index)) != null) {
                                        SubMonitor subMonitor2;
                                        try {
                                            try {
                                                ((IndexWriter)writer.get()).addDocument((Iterable)document);
                                            }
                                            catch (CorruptIndexException e) {
                                                this.getLogger().error("Index is corrupted! {}", (Object)this, (Object)e);
                                                throw new IllegalStateException(e);
                                            }
                                            catch (IOException e) {
                                                this.getLogger().error("Index is in problematic state! {}", (Object)this, (Object)e);
                                                throw new IllegalStateException(e);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            subMonitor2 = mon;
                                            synchronized (subMonitor2) {
                                                mon.worked(1);
                                            }
                                            throw throwable;
                                        }
                                        subMonitor2 = mon;
                                        synchronized (subMonitor2) {
                                            mon.worked(1);
                                        }
                                    }
                                    index += 2;
                                }
                            }
                            catch (DatabaseException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                        finally {
                            s.release();
                        }
                    });
                }
                try {
                    s.acquire(2);
                }
                catch (InterruptedException e) {
                    this.getLogger().error("Could not initialize index {}", (Object)this, (Object)e);
                }
                mon.subTask("Flushing");
                if (IndexPolicy.PERF_INDEX_INIT) {
                    System.out.println(String.valueOf(this.getDescriptor()) + "Wrote index at " + this.indexPath + " in " + 1.0E-9 * (double)(System.nanoTime() - start) + " seconds.");
                }
                result.complete(null);
            }
            finally {
                try {
                    this.closeWriter(writer.getAndSet(null));
                }
                finally {
                    FileUtils.uncheckedClose((Closeable)directory.getAndSet(null));
                }
            }
        }
        catch (Throwable t) {
            this.getLogger().error("Could not initialize index", t);
            result.completeExceptionally(t);
        }
    }

    public List<Object[]> debugDocs(IProgressMonitor monitor) throws ParseException, IOException, IndexingException {
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        TopDocs td = this.searcher.search((Query)query, Integer.MAX_VALUE);
        ScoreDoc[] scoreDocs = td.scoreDocs;
        ArrayList<Object[]> result = new ArrayList<Object[]>(scoreDocs.length);
        ScoreDoc[] scoreDocArray = scoreDocs;
        int n = scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc scoreDoc = scoreDocArray[n2];
            try {
                Document doc = this.reader.document(scoreDoc.doc);
                List fs = doc.getFields();
                Object[] o = new Object[fs.size()];
                int index = 0;
                for (IndexableField f : fs) {
                    o[index++] = f.stringValue();
                }
                result.add(o);
            }
            catch (CorruptIndexException e) {
                this.getLogger().error("Index is corrupted! {}", (Object)this, (Object)e);
                throw new IndexCorruptedException("Index is corrupted! " + this, e);
            }
            catch (IOException e) {
                this.getLogger().error("Index is in problematic state! {}", (Object)this, (Object)e);
                throw new IndexingException(e);
            }
            ++n2;
        }
        return result;
    }

    List<Map<String, Object>> doSearch(IProgressMonitor monitor, RequestProcessor processor, String search, int maxResultCount) throws ParseException, IOException, IndexingException {
        if (search.isEmpty()) {
            return Collections.emptyList();
        }
        this.assertAccessOpen(false);
        Query query = Queries.parse(search, this.schema);
        long start = System.nanoTime();
        maxResultCount = Math.min(maxResultCount, this.searcher.getIndexReader().numDocs());
        if (maxResultCount == 0) {
            return Collections.emptyList();
        }
        final TopDocs docs = this.searcher.search(query, null, maxResultCount);
        if (IndexPolicy.PERF_INDEX_QUERY) {
            long end = System.nanoTime();
            System.out.println(String.valueOf(this.getDescriptor()) + "search(" + search + ", " + maxResultCount + ") into index at " + this.indexPath + " took " + 1.0E-9 * (double)(end - start) + " seconds.");
        }
        if (docs.totalHits == 0) {
            return Collections.emptyList();
        }
        try {
            return (List)processor.syncRequest((Read)new Read<List<Map<String, Object>>>(){

                public List<Map<String, Object>> perform(ReadGraph graph) throws DatabaseException {
                    GenericRelation r = (GenericRelation)graph.adapt(IndexedRelationsSearcherBase.this.relation, GenericRelation.class);
                    if (r == null) {
                        throw new IndexingException("Given resource " + (String)graph.syncRequest((Read)new SafeName(IndexedRelationsSearcherBase.this.relation)) + "could not be adapted to GenericRelation.");
                    }
                    SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                    ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(docs.scoreDocs.length);
                    DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
                    ScoreDoc[] scoreDocArray = docs.scoreDocs;
                    int n = docs.scoreDocs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ScoreDoc scoreDoc = scoreDocArray[n2];
                        try {
                            IndexedRelationsSearcherBase.this.reader.document(scoreDoc.doc, (StoredFieldVisitor)visitor);
                            Document doc = visitor.getDocument();
                            List fs = doc.getFields();
                            THashMap entry = new THashMap(fs.size());
                            for (IndexableField f : fs) {
                                IndexSchema.Type type = IndexedRelationsSearcherBase.this.schema.typeMap.get(f.name());
                                if (type == IndexSchema.Type.LONG) {
                                    entry.put(f.name(), support.getResource(f.numericValue().longValue()));
                                    continue;
                                }
                                entry.put(f.name(), f.stringValue());
                            }
                            result.add((Map<String, Object>)entry);
                        }
                        catch (CorruptIndexException e) {
                            IndexedRelationsSearcherBase.this.getLogger().error("Index is corrupted! {}", (Object)this, (Object)e);
                            throw new IndexCorruptedException("Index is corrupted!  " + this + " " + scoreDoc, e);
                        }
                        catch (IOException e) {
                            IndexedRelationsSearcherBase.this.getLogger().error("Index is in problematic state! {}", (Object)this, (Object)e);
                            throw new IndexingException(e);
                        }
                        ++n2;
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            if (e instanceof IndexingException) {
                throw (IndexingException)((Object)e);
            }
            throw new IndexingException(e);
        }
    }

    List<Resource> doSearchResources(IProgressMonitor monitor, RequestProcessor processor, String search, int maxResultCount) throws ParseException, IOException, IndexingException {
        if (search.isEmpty()) {
            return Collections.emptyList();
        }
        this.assertAccessOpen(false);
        Query query = Queries.parse(search, this.schema);
        long start = System.nanoTime();
        maxResultCount = Math.min(maxResultCount, this.searcher.getIndexReader().numDocs());
        if (maxResultCount == 0) {
            return Collections.emptyList();
        }
        final TopDocs docs = this.searcher.search(query, null, maxResultCount);
        if (IndexPolicy.PERF_INDEX_QUERY) {
            long end = System.nanoTime();
            System.out.println(String.valueOf(this.getDescriptor()) + "search(" + search + ", " + maxResultCount + ") into index at " + this.indexPath + " took " + 1.0E-9 * (double)(end - start) + " seconds.");
        }
        if (docs.totalHits == 0) {
            return Collections.emptyList();
        }
        try {
            return (List)processor.syncRequest((Read)new Read<List<Resource>>(){

                public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                    CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
                    SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                    List result = cs.createList();
                    ResourceVisitor visitor = new ResourceVisitor();
                    ScoreDoc[] scoreDocArray = docs.scoreDocs;
                    int n = docs.scoreDocs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ScoreDoc scoreDoc = scoreDocArray[n2];
                        try {
                            IndexedRelationsSearcherBase.this.reader.document(scoreDoc.doc, (StoredFieldVisitor)visitor);
                            result.add(support.getResource(visitor.id));
                        }
                        catch (CorruptIndexException e) {
                            IndexedRelationsSearcherBase.this.getLogger().error("Index is corrupted! {}", (Object)this, (Object)e);
                            throw new IndexCorruptedException("Index is corrupted!  " + this + " " + scoreDoc, e);
                        }
                        catch (IOException e) {
                            IndexedRelationsSearcherBase.this.getLogger().error("Index is in problematic state! {}", (Object)this, (Object)e);
                            throw new IndexingException(e);
                        }
                        ++n2;
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            if (e instanceof IndexingException) {
                throw (IndexingException)((Object)e);
            }
            throw new IndexingException(e);
        }
    }

    List<Object> doList(IProgressMonitor monitor, RequestProcessor processor) throws ParseException, IOException, IndexingException {
        this.assertAccessOpen(false);
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        TopDocs docs = this.searcher.search((Query)query, Integer.MAX_VALUE);
        ArrayList<Object> result = new ArrayList<Object>();
        DumpVisitor visitor = new DumpVisitor(result);
        ScoreDoc[] scoreDocArray = docs.scoreDocs;
        int n = docs.scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc scoreDoc = scoreDocArray[n2];
            try {
                this.reader.document(scoreDoc.doc, (StoredFieldVisitor)visitor);
            }
            catch (CorruptIndexException e) {
                this.getLogger().error("Index is corrupted! {}", (Object)this, (Object)e);
                throw new IndexCorruptedException("Index is corrupted!  " + this + " " + scoreDoc, e);
            }
            catch (IOException e) {
                this.getLogger().error("Index is in problematic state! {}", (Object)this, (Object)e);
                throw new IndexingException(e);
            }
            ++n2;
        }
        return result;
    }

    protected static Path getIndexDirectory(Session session, Resource relation, Resource input) {
        Path path = DatabaseIndexing.getIndexLocation(session, relation, input);
        return path;
    }

    Path getIndexPath() {
        return this.indexPath;
    }

    boolean isIndexAvailable() {
        return Files.isDirectory(this.indexPath, new LinkOption[0]);
    }

    abstract Throwable bestEffortClear(IProgressMonitor var1, Session var2);

    Throwable clearDirectory(IProgressMonitor monitor, Session session) {
        Path file = this.getIndexPath();
        try {
            FileUtils.delete((Path)file);
        }
        catch (Throwable t) {
            this.getLogger().error("Could not delete directory {}", (Object)file.toAbsolutePath(), (Object)t);
            return t;
        }
        if (Files.exists(file, new LinkOption[0])) {
            return new IllegalStateException("Failed to delete directory " + file.toAbsolutePath());
        }
        return null;
    }

    private Field[] setFields(Field[] fs, Object[] result) {
        int i = 0;
        while (i < result.length) {
            Object value = result[i];
            if (value instanceof String) {
                if (IndexPolicy.DEBUG_INDEX_INIT) {
                    System.out.println(String.valueOf(this.getDescriptor()) + "index " + fs[i].name() + " = " + value + " : String");
                }
                fs[i].setStringValue((String)value);
            } else if (value instanceof Long) {
                if (IndexPolicy.DEBUG_INDEX_INIT) {
                    System.out.println(String.valueOf(this.getDescriptor()) + "index " + fs[i].name() + " = " + value + " : Long");
                }
                fs[i].setLongValue(((Long)value).longValue());
            } else {
                this.getLogger().error("Can only index Long and String fields, encountered " + value);
                return null;
            }
            ++i;
        }
        return fs;
    }

    protected abstract Logger getLogger();

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + String.valueOf(this.schema) + ", " + String.valueOf(this.relation) + ", " + String.valueOf(this.input) + ", " + String.valueOf(this.indexPath) + ", " + String.valueOf(this.directory) + ", " + String.valueOf((Object)this.state) + "]";
    }

    static class DumpVisitor
    extends StoredFieldVisitor {
        public List<Object> values;

        DumpVisitor(List<Object> values) {
            this.values = values;
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return StoredFieldVisitor.Status.YES;
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.values.add(value);
        }

        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            this.values.add(value);
        }
    }

    static class ResourceVisitor
    extends StoredFieldVisitor {
        public long id;

        ResourceVisitor() {
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            if ("Resource".equals(fieldInfo.name)) {
                return StoredFieldVisitor.Status.YES;
            }
            return StoredFieldVisitor.Status.NO;
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.id = value;
        }
    }

    protected static enum State {
        NONE,
        PROBLEM,
        READY,
        READ,
        WRITE;

    }
}

