/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.matching;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntDoubleHashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntDoubleProcedure;
import gnu.trove.procedure.TIntObjectProcedure;
import org.simantics.graph.matching.GraphMatching;
import org.simantics.graph.matching.GraphMatchingStrategy;
import org.simantics.graph.matching.Stat;

public enum VotingMatchingStrategy implements GraphMatchingStrategy
{
    INSTANCE;


    public static void vote(final TIntDoubleHashMap[] voting, int[] aToB, int[] bToA, Stat[] aStat, Stat[] bStat, String[] bNames) {
        final TIntObjectHashMap aMap = new TIntObjectHashMap();
        Stat[] statArray = aStat;
        int n = aStat.length;
        int n2 = 0;
        while (n2 < n) {
            Stat stat = statArray[n2];
            int mp = aToB[stat.p];
            if (mp >= 0 && aToB[stat.o] < 0) {
                TIntArrayList l = (TIntArrayList)aMap.get(mp);
                if (l == null) {
                    l = new TIntArrayList(2);
                    aMap.put(mp, (Object)l);
                }
                l.add(stat.o);
            }
            ++n2;
        }
        TIntObjectHashMap bMap = new TIntObjectHashMap();
        Stat[] statArray2 = bStat;
        int n3 = bStat.length;
        n = 0;
        while (n < n3) {
            Stat stat = statArray2[n];
            int p = stat.p;
            int o = stat.o;
            if (bToA[p] >= 0 && bToA[o] < 0) {
                TIntArrayList l = (TIntArrayList)bMap.get(p);
                if (l == null) {
                    l = new TIntArrayList(2);
                    bMap.put(p, (Object)l);
                }
                l.add(o);
            }
            ++n;
        }
        bMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntArrayList>(){

            public boolean execute(int p, TIntArrayList bos) {
                TIntArrayList aos = (TIntArrayList)aMap.get(p);
                if (aos != null && aos.size() <= 4 && bos.size() <= 4) {
                    double weight = 1.0 / (double)bos.size();
                    int i = 0;
                    while (i < aos.size()) {
                        int j = 0;
                        while (j < bos.size()) {
                            voting[aos.get(i)].adjustOrPutValue(bos.get(j), weight, weight);
                            ++j;
                        }
                        ++i;
                    }
                }
                return true;
            }
        });
    }

    @Override
    public void applyTo(GraphMatching matching) {
        int[] aToB = matching.aToB;
        final int[] bToA = matching.bToA;
        int resourceCount = aToB.length;
        Stat[][] aStatements = matching.aGraph.statements;
        Stat[][] bStatements = matching.bGraph.statements;
        TIntIntHashMap aInv = matching.aGraph.inverses;
        TIntIntHashMap bInv = matching.bGraph.inverses;
        TIntDoubleHashMap[] voting = new TIntDoubleHashMap[resourceCount];
        int i = 0;
        while (i < resourceCount) {
            if (aToB[i] < 0) {
                voting[i] = new TIntDoubleHashMap();
            }
            ++i;
        }
        int s = 0;
        while (s < resourceCount) {
            int ms = aToB[s];
            if (ms >= 0 && ms < bStatements.length) {
                VotingMatchingStrategy.vote(voting, aToB, bToA, aStatements[s], bStatements[ms], matching.bGraph.names);
            }
            ++s;
        }
        int a = 0;
        while (a < resourceCount) {
            TIntDoubleHashMap votes = voting[a];
            if (votes != null && !votes.isEmpty()) {
                final int[] best = new int[]{-1};
                votes.forEachEntry(new TIntDoubleProcedure(){
                    double bestWeight = 0.9;

                    public boolean execute(int b, double weight) {
                        if (weight > this.bestWeight && bToA[b] < 0) {
                            this.bestWeight = weight;
                            best[0] = b;
                        }
                        return true;
                    }
                });
                if (best[0] >= 0) {
                    int b = best[0];
                    matching.map(a, b);
                    if (aInv.contains(a) && bInv.contains(b) && aInv.get(a) != a) {
                        matching.map(aInv.get(a), bInv.get(b));
                    }
                }
            }
            ++a;
        }
    }
}

