/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.impl.ConnectionSelectionOutline;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.elementclass.MonitorHandler;
import org.simantics.g2d.utils.GeometryUtils;

public class PickRequest {
    public Shape pickArea;
    public PickPolicy pickPolicy = PickPolicy.PICK_INTERSECTING_OBJECTS;
    public PickFilter pickFilter = null;
    public PickSorter pickSorter = null;
    public ICanvasContext pickContext;

    public PickRequest(double x, double y) {
        this.pickArea = new Rectangle2D.Double(x, y, 1.0, 1.0);
    }

    public PickRequest(Point2D p) {
        this.pickArea = new Rectangle2D.Double(p.getX(), p.getY(), 1.0E-4, 1.0E-4);
    }

    public PickRequest(Shape shape) {
        this.pickArea = shape;
    }

    public PickRequest(Shape shape, AffineTransform transform) {
        this.pickArea = GeometryUtils.transformShape(shape, transform);
    }

    public PickRequest context(ICanvasContext ctx) {
        this.pickContext = ctx;
        return this;
    }

    public static interface PickFilter {
        public static final PickFilter FILTER_ALL = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return true;
            }
        };
        public static final PickFilter FILTER_CONNECTIONS = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(ConnectionHandler.class);
            }

            public String toString() {
                return "FILTER_CONNECTIONS";
            }
        };
        public static final PickFilter FILTER_CONNECTION_EDGES = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(BendsHandler.class) || e.getElementClass().containsClass(ConnectionSelectionOutline.class);
            }

            public String toString() {
                return "FILTER_CONNECTION_EDGES";
            }
        };
        public static final PickFilter FILTER_BRANCH_POINT = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(BranchPoint.class);
            }

            public String toString() {
                return "FILTER_BRANCH_POINTS";
            }
        };
        public static final PickFilter FILTER_NODES = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(TerminalTopology.class);
            }

            public String toString() {
                return "FILTER_NODES";
            }
        };
        public static final PickFilter FILTER_MONITORS = new PickFilter(){

            @Override
            public boolean accept(IElement e) {
                return e.getElementClass().containsClass(MonitorHandler.class);
            }

            public String toString() {
                return "FILTER_MONITORS";
            }
        };

        public boolean accept(IElement var1);
    }

    public static enum PickPolicy {
        PICK_INTERSECTING_OBJECTS,
        PICK_CONTAINED_OBJECTS;

    }

    public static interface PickSorter {
        public static final PickSorter CONNECTIONS_LAST = new PickSorter(){

            @Override
            public void sort(List<IElement> elements) {
                Collections.sort(elements, new Comparator<IElement>(){

                    @Override
                    public int compare(IElement e1, IElement e2) {
                        boolean isConn1 = PickFilter.FILTER_CONNECTION_EDGES.accept(e1);
                        boolean isConn2 = PickFilter.FILTER_CONNECTION_EDGES.accept(e2);
                        if (!isConn1 && isConn2) {
                            return -1;
                        }
                        if (isConn1 && !isConn2) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
        };
        public static final PickSorter CONNECTIONS_FIRST = new PickSorter(){

            @Override
            public void sort(List<IElement> elements) {
                Collections.sort(elements, new Comparator<IElement>(){

                    @Override
                    public int compare(IElement e1, IElement e2) {
                        boolean isConn1 = PickFilter.FILTER_CONNECTION_EDGES.accept(e1);
                        boolean isConn2 = PickFilter.FILTER_CONNECTION_EDGES.accept(e2);
                        if (!isConn1 && isConn2) {
                            return 1;
                        }
                        if (isConn1 && !isConn2) {
                            return -1;
                        }
                        return 0;
                    }
                });
            }
        };

        public void sort(List<IElement> var1);
    }
}

