/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.canvas.impl;

import org.simantics.g2d.canvas.IMouseCaptureHandle;
import org.simantics.g2d.canvas.IMouseCaptureHandleListener;
import org.simantics.utils.datastructures.ListenerList;

public class MouseCaptureHandle
implements IMouseCaptureHandle {
    boolean released = false;
    final int mouseId;
    ListenerList<IMouseCaptureHandleListener> listeners;

    public MouseCaptureHandle(int mouseId) {
        this.mouseId = mouseId;
    }

    @Override
    public int mouseId() {
        return this.mouseId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        MouseCaptureHandle mouseCaptureHandle = this;
        synchronized (mouseCaptureHandle) {
            if (this.released) {
                return;
            }
            this.released = true;
        }
        this.fireOnReleased();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireOnReleased() {
        ListenerList<IMouseCaptureHandleListener> lis;
        MouseCaptureHandle mouseCaptureHandle = this;
        synchronized (mouseCaptureHandle) {
            lis = this.listeners;
            if (lis == null) {
                return;
            }
        }
        IMouseCaptureHandleListener[] iMouseCaptureHandleListenerArray = (IMouseCaptureHandleListener[])lis.getListeners();
        int n = iMouseCaptureHandleListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMouseCaptureHandleListener l = iMouseCaptureHandleListenerArray[n2];
            l.onCaptureReleased(this);
            ++n2;
        }
    }

    @Override
    public void removeMouseCaptureHandleListener(IMouseCaptureHandleListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)listener);
    }

    @Override
    public synchronized void addMouseCaptureHandleListener(IMouseCaptureHandleListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList(IMouseCaptureHandleListener.class);
        }
        this.listeners.add((Object)listener);
    }
}

