/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.basicexpression;

import java.io.PushbackReader;
import java.io.StringReader;
import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.basicexpression.lexer.Lexer;
import org.simantics.basicexpression.node.Start;
import org.simantics.basicexpression.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expressions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Expressions.class);
    private static final boolean DEBUG = false;

    public static void evaluate(String expression, DepthFirstAdapter evaluator) {
        try {
            Parser p = new Parser(new Lexer(new PushbackReader(new StringReader(expression))));
            Start tree = p.parse();
            tree.apply(evaluator);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to evaluate expression {}", (Object)expression, (Object)e);
            }
            evaluator.except(e);
        }
    }
}

