/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import gnu.trove.list.array.TByteArrayList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandMetadata
implements Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandMetadata.class);
    public static final boolean DEBUG = false;
    public static final String RESET_COMMAND = "// RESET";
    private static final Binding BINDING = Bindings.getBindingUnchecked(CommandMetadata.class);
    private static final Serializer SERIALIZER = Bindings.getSerializerUnchecked((Binding)BINDING);
    public List<Command> commands;

    public byte[] serialise(Session session) {
        try {
            TByteArrayList commandsSerialized = new TByteArrayList(4096);
            byte[] bytes = new byte[8];
            int commandsSize = this.commands.size();
            Bytes.writeLE((byte[])bytes, (int)0, (int)commandsSize);
            commandsSerialized.add(bytes, 0, 4);
            for (Command command : this.commands) {
                Bytes.writeLE8((byte[])bytes, (int)0, (long)command.modelId);
                commandsSerialized.add(bytes);
                byte[] commandBytes = command.command.getBytes(StandardCharsets.UTF_8);
                Bytes.writeLE((byte[])bytes, (int)0, (int)commandBytes.length);
                commandsSerialized.add(bytes, 0, 4);
                commandsSerialized.add(commandBytes);
            }
            return commandsSerialized.toArray();
        }
        catch (Exception ee) {
            try {
                return SERIALIZER.serialize((Object)this);
            }
            catch (IOException e) {
                LOGGER.error("Could not serialize", (Throwable)e);
                LOGGER.error("Original exception for new serialisation", (Throwable)ee);
                throw new RuntimeException(e);
            }
        }
    }

    public static CommandMetadata deserialise(Session session, byte[] input) {
        if (input == null) {
            CommandMetadata metadata = new CommandMetadata();
            metadata.commands = new ArrayList<Command>();
            return metadata;
        }
        try {
            int byteIndex = 0;
            int commandsSize = Bytes.readLE4((byte[])input, (int)byteIndex);
            byteIndex += 4;
            ArrayList<Command> commands = new ArrayList<Command>(commandsSize);
            int i = 0;
            while (i < commandsSize) {
                long modelId = Bytes.readLE8((byte[])input, (int)byteIndex);
                int commandsLength = Bytes.readLE4((byte[])input, (int)(byteIndex += 8));
                String command = new String(input, byteIndex += 4, commandsLength);
                byteIndex += commandsLength;
                Command comm = new Command(modelId, command);
                commands.add(comm);
                ++i;
            }
            CommandMetadata metadata = new CommandMetadata();
            metadata.commands = commands;
            return metadata;
        }
        catch (Exception ee) {
            try {
                return (CommandMetadata)SERIALIZER.deserialize(input);
            }
            catch (Exception e) {
                LOGGER.error("Could not deserialise", (Throwable)e);
                LOGGER.error("Original exception for new deserialisation", (Throwable)ee);
                return null;
            }
        }
    }

    public CommandMetadata add(Command command) {
        this.commands.add(command);
        return this;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public static void add(WriteGraph graph, long modelId, String command) throws DatabaseException {
        graph.addMetadata((Metadata)((CommandMetadata)graph.getMetadata(CommandMetadata.class)).add(new Command(modelId, command)));
    }

    public static void addReset(WriteGraph graph, long modelId) throws DatabaseException {
        graph.addMetadata((Metadata)((CommandMetadata)graph.getMetadata(CommandMetadata.class)).add(new Command(modelId, RESET_COMMAND)));
    }

    public static final class Command {
        public long modelId;
        public String command;

        public Command() {
        }

        public Command(long modelId, String command) {
            this.modelId = modelId;
            this.command = command;
        }
    }
}

