/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.TagUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

class PreferenceHandler
extends AbstractHandler
implements IElementUpdater,
ActionFactory,
ActionFactory2 {
    protected final String virtualGraphId;
    private final String tagURI;
    private final boolean tag;

    public PreferenceHandler() {
        this("preferences", null, false);
    }

    public PreferenceHandler(String tagURI, boolean tag) {
        this("preferences", tagURI, tag);
    }

    public PreferenceHandler(String virtualGraphId) {
        this(virtualGraphId, null, false);
    }

    public PreferenceHandler(String virtualGraphId, String tagURI, boolean tag) {
        this.virtualGraphId = virtualGraphId;
        this.tagURI = tagURI;
        this.tag = tag;
    }

    public ArrayList<Resource> filteredSelection(ReadGraph graph, List<Resource> resources, List<Variable> vars) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> sel = new ArrayList<Resource>();
        for (Variable v : vars) {
            Resource r = v.getPossibleRepresents(graph);
            if (r == null || !graph.isInstanceOf(r, ISSUE.Issue)) continue;
            sel.add(r);
        }
        for (Resource r : resources) {
            if (!graph.isInstanceOf(r, ISSUE.Issue)) continue;
            sel.add(r);
        }
        return sel;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        ISelectionProvider sp = site.getSelectionProvider();
        ISelection selection = sp.getSelection();
        List vars = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Variable.class);
        List resources = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        this.execute(vars, resources);
        return null;
    }

    public void execute(final List<Variable> vars, List<Resource> resources) {
        Session session = Simantics.peekSession();
        if (session == null) {
            return;
        }
        new TagUtil(this.virtualGraphId, this.tagURI, this.tag){

            protected void processSelection(WriteGraph graph, List<Resource> resources) throws DatabaseException {
                graph.markUndoPoint();
                ArrayList<Resource> sel = PreferenceHandler.this.filteredSelection((ReadGraph)graph, resources, vars);
                if (!PreferenceHandler.this.process(graph)) {
                    return;
                }
                super.processSelection(graph, sel);
            }
        }.execute(session, resources);
    }

    protected boolean process(WriteGraph graph) throws DatabaseException {
        return true;
    }

    public void updateElement(UIElement element, Map parameters) {
        Session session = Simantics.peekSession();
        if (session == null) {
            return;
        }
        try {
            boolean checked = (Boolean)session.syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    return PreferenceHandler.this.isChecked(graph);
                }
            });
            element.setChecked(checked);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    protected boolean isChecked(ReadGraph graph) throws DatabaseException {
        return false;
    }

    public Runnable create(Object target) {
        if (!(target instanceof Variable)) {
            return null;
        }
        final Variable issue = (Variable)target;
        return new Runnable(){

            @Override
            public void run() {
                PreferenceHandler.this.execute(Collections.singletonList(issue), Collections.emptyList());
            }
        };
    }

    public Runnable create(Collection<?> targets) {
        final ArrayList issues = new ArrayList(ISelectionUtils.filterSetSelection(targets, Variable.class));
        if (issues.isEmpty()) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                PreferenceHandler.this.execute(issues, Collections.emptyList());
            }
        };
    }
}

