/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.writer;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaStaticField;
import org.simantics.scl.compiler.constants.SCLConstant;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAModule;
import org.simantics.scl.compiler.internal.codegen.ssa.StaticField;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.codegen.writer.ExternalConstant;
import org.simantics.scl.compiler.internal.parsing.utils.LineLocator;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.tuple.Tuple2;

public class ModuleWriter {
    SSAModule module;
    LineLocator lineLocator;
    String moduleClassName;
    THashMap<Tuple2, JavaStaticField> externalConstantMap = new THashMap();
    int externalConstantId = 0;

    public ModuleWriter(String moduleClassName, LineLocator lineLocator) {
        this.module = new SSAModule();
        this.moduleClassName = moduleClassName;
        this.lineLocator = lineLocator;
    }

    public CodeWriter createFunction(SCLConstant constant, TVar[] typeParameters, Type effect, Type returnType, Type[] parameterTypes) {
        Name name = constant.getName();
        SSAFunction function = new SSAFunction(typeParameters, effect, returnType);
        SSABlock block = new SSABlock(parameterTypes);
        function.addBlock(block);
        function.setTarget(constant);
        constant.setDefinition(function);
        this.module.put(name, constant);
        return new CodeWriter(this, block);
    }

    public String toString() {
        return this.module.toString();
    }

    public SSAModule getModule() {
        return this.module;
    }

    public Constant getExternalConstant(Object value, Type type) {
        Tuple2 tuple = new Tuple2(value, (Object)type);
        if (this.externalConstantMap.contains((Object)tuple)) {
            return (Constant)this.externalConstantMap.get((Object)tuple);
        }
        ++this.externalConstantId;
        String name = "externalConstant" + this.externalConstantId;
        JavaStaticField constant = new JavaStaticField(this.moduleClassName, name, type, -1);
        this.externalConstantMap.put((Object)tuple, (Object)constant);
        this.module.addStaticField(new StaticField(name, type));
        return constant;
    }

    public ExternalConstant[] getExternalConstants() {
        ExternalConstant[] result = new ExternalConstant[this.externalConstantMap.size()];
        int i = 0;
        for (Map.Entry entry : this.externalConstantMap.entrySet()) {
            result[i++] = new ExternalConstant(((JavaStaticField)entry.getValue()).getFieldName(), ((Tuple2)entry.getKey()).c0);
        }
        return result;
    }
}

