/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRQuery;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.plan.CHRSearchPlan;
import org.simantics.scl.compiler.elaboration.chr.planning.QueryPlanningContext;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class CHRRule
extends Symbol {
    public CHRRuleset parentRuleset;
    public int priority;
    public CHRQuery head;
    public CHRQuery body;
    public Variable[] existentialVariables;
    public int lastPriorityExecuted;
    public ArrayList<CHRSearchPlan> plans = new ArrayList();
    public String containerClassName;

    public CHRRule(long location, CHRQuery head, CHRQuery body, Variable[] existentialVariables) {
        this.location = location;
        this.head = head;
        this.body = body;
        this.existentialVariables = existentialVariables;
    }

    public CHRRule(long location, CHRQuery head, CHRQuery body) {
        this(location, head, body, null);
    }

    public void resolve(TranslationContext context) {
        context.pushExistentialFrame();
        this.head.resolve(context);
        context.disallowNewExistentials();
        this.body.resolve(context);
        this.existentialVariables = context.popExistentialFrame();
    }

    public void checkType(TypingContext context) {
        Variable[] variableArray = this.existentialVariables;
        int n = this.existentialVariables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variable.setType(Types.metaVar(Kinds.STAR));
            ++n2;
        }
        this.head.checkType(context);
        this.body.checkType(context);
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.head.collectVars(allVars, vars);
        this.body.collectVars(allVars, vars);
    }

    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.head.setLocationDeep(loc);
            this.body.setLocationDeep(loc);
        }
    }

    public void simplify(SimplificationContext context) {
        this.head.simplify(context);
        this.body.simplify(context);
    }

    public void compile(CompilationContext compilationContext, CHRConstraint initConstraint) {
        boolean hasLocalActiveLiteral = false;
        int i = 0;
        while (i < this.head.literals.length) {
            CHRLiteral literal = this.head.literals[i];
            if (!literal.passive) {
                CHRConstraint constraint = (CHRConstraint)literal.relation;
                QueryPlanningContext context = new QueryPlanningContext(compilationContext, this.existentialVariables);
                Variable activeFact = new Variable("activeFact", constraint.factType);
                if (!this.head.createQueryPlan(context, new EVariable(activeFact), i, initConstraint)) {
                    return;
                }
                this.body.createEnforcePlan(context, this.priority);
                this.addPlan(new CHRSearchPlan(constraint, activeFact, context.getPlanOps()));
                if (constraint.parentRuleset == this.parentRuleset) {
                    hasLocalActiveLiteral = true;
                }
            }
            ++i;
        }
        if (!hasLocalActiveLiteral) {
            QueryPlanningContext context = new QueryPlanningContext(compilationContext, this.existentialVariables);
            Variable activeFact = new Variable("activeFact", initConstraint.factType);
            if (!this.head.createQueryPlan(context, new EVariable(activeFact), -1, initConstraint)) {
                return;
            }
            this.body.createEnforcePlan(context, this.priority);
            this.addPlan(new CHRSearchPlan(initConstraint, activeFact, context.getPlanOps()));
        }
    }

    private void addPlan(CHRSearchPlan plan) {
        this.plans.add(plan);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
        visitor.visit(this);
        return b.toString();
    }
}

