/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.prioritystack;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.simantics.utils.datastructures.prioritystack.IPriorityStack;
import org.simantics.utils.datastructures.prioritystack.IPriorityStackListener;
import org.simantics.utils.strings.EString;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;

public class PriorityStack<E>
implements IPriorityStack<E> {
    private SyncListenerList<IPriorityStackListener> listeners = new SyncListenerList(IPriorityStackListener.class);
    private LinkedList<E> list = new LinkedList();
    private E[] snapshotArray;
    private Map<E, Integer> priorities = new HashMap<E, Integer>();
    final Class<E> clazz;
    private static Method itemAdded = SyncListenerList.getMethod(IPriorityStackListener.class, (String)"itemAdded");
    private static Method itemRemoved = SyncListenerList.getMethod(IPriorityStackListener.class, (String)"itemRemoved");

    public PriorityStack(Class<E> clazz) {
        this.clazz = clazz;
        this.snapshotArray = this.createArray(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(E interactor, int priority) {
        block6: {
            PriorityStack priorityStack = this;
            synchronized (priorityStack) {
                if (this.list.contains(interactor)) {
                    throw new IllegalArgumentException("InteractorStack already contains item " + interactor);
                }
                this.priorities.put(interactor, priority);
                if (this.list.size() == 0) {
                    this.list.add(interactor);
                    this.snapshotArray = this.createSnapshot(this.list);
                    break block6;
                }
                ListIterator<E> li = this.list.listIterator();
                while (li.hasNext()) {
                    Object i = li.next();
                    double w = this.priorities.get(i).intValue();
                    if (!(w > (double)priority)) continue;
                    li.previous();
                    li.add(interactor);
                    this.snapshotArray = this.createSnapshot(this.list);
                    break block6;
                }
                this.list.addLast(interactor);
                this.snapshotArray = this.createSnapshot(this.list);
            }
        }
        this.fireInteractorAdded(interactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(E interactor) {
        PriorityStack priorityStack = this;
        synchronized (priorityStack) {
            block4: {
                if (this.priorities.containsKey(interactor)) break block4;
                return false;
            }
            this.priorities.remove(interactor);
            this.list.remove(interactor);
            this.snapshotArray = this.createSnapshot(this.list);
        }
        this.fireInteractorRemoved(interactor);
        return true;
    }

    @Override
    public synchronized Integer getPriority(E interactor) {
        return this.priorities.get(interactor);
    }

    private E[] createArray(int length) {
        return (Object[])Array.newInstance(this.clazz, length);
    }

    E[] createSnapshot(List<E> list) {
        E[] result = this.createArray(list.size());
        int index = 0;
        for (E i : list) {
            result[index++] = i;
        }
        return result;
    }

    public synchronized int indexOf(E item) {
        int i = 0;
        while (i < this.snapshotArray.length) {
            if (this.snapshotArray[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public synchronized E[] toArray() {
        return this.snapshotArray;
    }

    @Override
    public synchronized <R extends E> R getSingleItem(Class<R> clazz) {
        R[] array = this.getItemsByClass(clazz);
        if (array.length != 1) {
            throw new RuntimeException("one " + clazz.getName() + " expected in PriorityStack, got " + array.length);
        }
        return array[0];
    }

    @Override
    public synchronized <R extends E> R[] getItemsByClass(Class<R> clazz) {
        ArrayList result = new ArrayList(this.list.size());
        for (Object i : this.list) {
            if (!clazz.isAssignableFrom(i.getClass())) continue;
            result.add(i);
        }
        return result.toArray(this.createArray(result.size()));
    }

    private void fireInteractorAdded(E interactor) {
        this.listeners.fireEventSync(itemAdded, new Object[]{this, interactor});
    }

    private void fireInteractorRemoved(E interactor) {
        this.listeners.fireEventSync(itemRemoved, new Object[]{this, interactor});
    }

    @Override
    public synchronized void addStackListener(IPriorityStackListener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeStackListener(IPriorityStackListener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized boolean contains(E interactor) {
        return this.list.contains(interactor);
    }

    @Override
    public void addStackListener(IThreadWorkQueue thread, IPriorityStackListener<E> listener) {
        this.listeners.add(thread, listener);
    }

    @Override
    public void removeStackListener(IThreadWorkQueue thread, IPriorityStackListener<E> listener) {
        this.listeners.remove(thread, listener);
    }

    public String toString() {
        return EString.implode((Object[])this.snapshotArray, (String)"\n");
    }
}

