/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.persistent;

import gnu.trove.procedure.TObjectObjectProcedure;

public class ImmutableMap<T extends Comparable<T>, V> {
    static final ImmutableMap EMPTY = new EmptyImmutableSet();
    ImmutableMap<T, V> left;
    T key;
    V value;
    ImmutableMap<T, V> right;
    boolean isBlack;

    protected ImmutableMap(ImmutableMap<T, V> left, T key, V value, ImmutableMap<T, V> right, boolean isBlack) {
        this.left = left;
        this.right = right;
        this.key = key;
        this.value = value;
        this.isBlack = isBlack;
    }

    public ImmutableMap(T key, V value) {
        this(EMPTY, key, value, EMPTY, false);
    }

    private ImmutableMap() {
    }

    public boolean contains(T obj) {
        int cmp = obj.compareTo(this.key);
        if (cmp < 0) {
            return this.left.contains(obj);
        }
        if (cmp > 0) {
            return this.right.contains(obj);
        }
        return true;
    }

    public V get(T key) {
        int cmp = key.compareTo(key);
        if (cmp < 0) {
            return this.left.get(key);
        }
        if (cmp > 0) {
            return this.right.get(key);
        }
        return this.value;
    }

    protected ImmutableMap<T, V> putRec(T obj, V value) {
        int cmp = obj.compareTo(this.key);
        if (cmp < 0) {
            ImmutableMap<T, V> newLeft = this.left.putRec(obj, value);
            if (newLeft == this.left) {
                return this;
            }
            if (this.isBlack) {
                return ImmutableMap.balance(newLeft, this.key, value, this.right);
            }
            return ImmutableMap.red(newLeft, this.key, value, this.right);
        }
        if (cmp > 0) {
            ImmutableMap<T, V> newRight = this.right.putRec(obj, value);
            if (newRight == this.right) {
                return this;
            }
            if (this.isBlack) {
                return ImmutableMap.balance(this.left, this.key, value, newRight);
            }
            return ImmutableMap.red(this.left, this.key, value, newRight);
        }
        return this;
    }

    protected ImmutableMap<T, V> removeRec(T obj) {
        int cmp = obj.compareTo(this.key);
        if (cmp < 0) {
            ImmutableMap<T, V> newLeft = this.left.removeRec(obj);
            if (newLeft == null) {
                return null;
            }
            if (this.left.isBlack) {
                return ImmutableMap.balleft(newLeft, this.key, this.value, this.right);
            }
            return ImmutableMap.red(newLeft, this.key, this.value, this.right);
        }
        if (cmp > 0) {
            ImmutableMap<T, V> newRight = this.right.removeRec(obj);
            if (newRight == null) {
                return null;
            }
            if (this.right.isBlack) {
                return ImmutableMap.balright(this.left, this.key, this.value, newRight);
            }
            return ImmutableMap.red(this.left, this.key, this.value, newRight);
        }
        return ImmutableMap.append(this.left, this.right);
    }

    protected static <T extends Comparable<T>, V> ImmutableMap<T, V> append(ImmutableMap<T, V> a, ImmutableMap<T, V> b) {
        if (a == EMPTY) {
            return b;
        }
        if (b == EMPTY) {
            return a;
        }
        if (a.isBlack) {
            if (b.isBlack) {
                ImmutableMap<T, V> middle = ImmutableMap.append(a.right, b.left);
                if (middle.isBlack) {
                    return ImmutableMap.balleft(a.left, a.key, a.value, ImmutableMap.black(middle, b.key, b.value, b.right));
                }
                return ImmutableMap.red(ImmutableMap.black(a.left, a.key, a.value, middle.left), middle.key, middle.value, ImmutableMap.black(middle.right, b.key, b.value, b.right));
            }
            return ImmutableMap.red(ImmutableMap.append(a, b.left), b.key, b.value, b.right);
        }
        if (b.isBlack) {
            return ImmutableMap.red(a.left, a.key, a.value, ImmutableMap.append(a.right, b));
        }
        ImmutableMap<T, V> middle = ImmutableMap.append(a.right, b.left);
        if (middle.isBlack) {
            return ImmutableMap.red(a.left, a.key, a.value, ImmutableMap.red(middle, b.key, b.value, b.right));
        }
        return ImmutableMap.red(ImmutableMap.red(a.left, a.key, a.value, middle.left), middle.key, middle.value, ImmutableMap.red(middle.right, b.key, b.value, b.right));
    }

    public T getFirst() {
        if (this.left == EMPTY) {
            return this.key;
        }
        return this.left.getFirst();
    }

    private static <T extends Comparable<T>, V> ImmutableMap<T, V> balance(ImmutableMap<T, V> left, T key, V value, ImmutableMap<T, V> right) {
        if (!left.isBlack) {
            if (!left.left.isBlack) {
                return ImmutableMap.red(ImmutableMap.toBlack(left.left), left.key, left.value, ImmutableMap.black(left.right, key, value, right));
            }
            if (!left.right.isBlack) {
                return ImmutableMap.red(ImmutableMap.black(left.left, left.key, left.value, left.right.left), left.right.key, left.right.value, ImmutableMap.black(left.right.right, key, value, right));
            }
        }
        if (!right.isBlack) {
            if (!right.left.isBlack) {
                return ImmutableMap.red(ImmutableMap.black(left, key, value, right.left.left), right.left.key, right.left.value, ImmutableMap.black(right.left.right, right.key, right.value, right.right));
            }
            if (!right.right.isBlack) {
                return ImmutableMap.red(ImmutableMap.black(left, key, value, right.left), right.key, right.value, ImmutableMap.toBlack(right.right));
            }
        }
        return ImmutableMap.black(left, key, value, right);
    }

    private static <T extends Comparable<T>, V> ImmutableMap<T, V> black(ImmutableMap<T, V> left, T key, V value, ImmutableMap<T, V> right) {
        return new ImmutableMap<T, V>(left, key, value, right, true);
    }

    private static <T extends Comparable<T>, V> ImmutableMap<T, V> red(ImmutableMap<T, V> left, T key, V value, ImmutableMap<T, V> right) {
        return new ImmutableMap<T, V>(left, key, value, right, false);
    }

    private static <T extends Comparable<T>, V> ImmutableMap<T, V> toBlack(ImmutableMap<T, V> tree) {
        if (tree.isBlack) {
            return tree;
        }
        return ImmutableMap.black(tree.left, tree.key, tree.value, tree.right);
    }

    private static <T extends Comparable<T>, V> ImmutableMap<T, V> toRed(ImmutableMap<T, V> tree) {
        if (tree.isBlack) {
            return ImmutableMap.red(tree.left, tree.key, tree.value, tree.right);
        }
        return tree;
    }

    private static <T extends Comparable<T>, V> ImmutableMap<T, V> balleft(ImmutableMap<T, V> left, T key, V value, ImmutableMap<T, V> right) {
        if (left.isBlack) {
            if (right.isBlack) {
                return ImmutableMap.balance(left, key, value, ImmutableMap.toRed(right));
            }
            return ImmutableMap.red(ImmutableMap.black(left, key, value, right.left.left), right.left.key, right.left.value, ImmutableMap.balance(right.left.right, right.key, right.value, ImmutableMap.toRed(right.right)));
        }
        return ImmutableMap.red(ImmutableMap.toBlack(left), key, value, right);
    }

    private static <T extends Comparable<T>, V> ImmutableMap<T, V> balright(ImmutableMap<T, V> left, T key, V value, ImmutableMap<T, V> right) {
        if (right.isBlack) {
            if (left.isBlack) {
                return ImmutableMap.balance(ImmutableMap.toRed(left), key, value, right);
            }
            return ImmutableMap.red(ImmutableMap.balance(ImmutableMap.toRed(left.left), left.key, left.value, left.right.left), left.right.key, left.right.value, ImmutableMap.black(left.right.right, key, value, right));
        }
        return ImmutableMap.red(left, key, value, ImmutableMap.toBlack(right));
    }

    public ImmutableMap<T, V> put(T key, V value) {
        ImmutableMap<T, V> tree = this.putRec(key, value);
        tree.isBlack = true;
        return tree;
    }

    public ImmutableMap<T, V> remove(T obj) {
        ImmutableMap<T, V> tree = this.removeRec(obj);
        if (tree == null) {
            return this;
        }
        if (tree.isBlack) {
            return tree;
        }
        return ImmutableMap.black(tree.left, tree.key, tree.value, tree.right);
    }

    public boolean forEach(TObjectObjectProcedure<T, V> proc) {
        if (this.left.forEach(proc) && proc.execute(this.key, this.value)) {
            return this.right.forEach(proc);
        }
        return false;
    }

    /* synthetic */ ImmutableMap(ImmutableMap immutableMap) {
        this();
    }

    private static class EmptyImmutableSet<T extends Comparable<T>, V>
    extends ImmutableMap<T, V> {
        public EmptyImmutableSet() {
            super(null);
            this.isBlack = true;
        }

        @Override
        protected ImmutableMap<T, V> putRec(T key, V value) {
            return new ImmutableMap<T, V>(key, value);
        }

        @Override
        protected ImmutableMap<T, V> removeRec(T obj) {
            return null;
        }

        @Override
        public boolean contains(T obj) {
            return false;
        }

        @Override
        public V get(T key) {
            return null;
        }

        @Override
        public boolean forEach(TObjectObjectProcedure<T, V> arg0) {
            return true;
        }
    }
}

