/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbolcontribution.AbstractSymbolProvider;
import org.simantics.diagram.symbolcontribution.BasicSymbolProviderFactory;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactories;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.layer0.Layer0;

public class IndexRootSymbolProviderFactory
implements SymbolProviderFactory {
    Resource indexRoot;
    Resource diagram;

    public IndexRootSymbolProviderFactory(Resource indexRoot, Resource diagram) {
        this.indexRoot = indexRoot;
        this.diagram = diagram;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.diagram == null ? 0 : this.diagram.hashCode());
        result = 31 * result + (this.indexRoot == null ? 0 : this.indexRoot.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexRootSymbolProviderFactory other = (IndexRootSymbolProviderFactory)obj;
        if (this.diagram == null ? other.diagram != null : !this.diagram.equals(other.diagram)) {
            return false;
        }
        return !(this.indexRoot == null ? other.indexRoot != null : !this.indexRoot.equals(other.indexRoot));
    }

    @Override
    public ISymbolProvider create(ReadGraph g) throws DatabaseException {
        return (ISymbolProvider)g.syncRequest((Read)new LoadRequest(this.indexRoot, this.diagram));
    }

    static class LoadRequest
    extends BinaryRead<Resource, Resource, ISymbolProvider> {
        public LoadRequest(Resource contribution, Resource diagram) {
            super((Object)contribution, (Object)diagram);
        }

        public ISymbolProvider perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
            ArrayList<ISymbolGroup> groups = new ArrayList<ISymbolGroup>();
            if (this.parameter != null) {
                Instances query = (Instances)graph.adapt(dr.SymbolReferenceLibrary, Instances.class);
                for (Resource library : query.find(graph, (Resource)this.parameter)) {
                    if (!SymbolProviderFactories.accept(graph, dr, library, (Resource)this.parameter2)) continue;
                    groups.add(BasicSymbolProviderFactory.createGroup(graph, library, L0.IsRelatedTo, (Resource)this.parameter2));
                }
            }
            return new SymbolProvider(groups);
        }
    }

    static class SymbolProvider
    extends AbstractSymbolProvider {
        public SymbolProvider(Collection<ISymbolGroup> groups) {
            this.setSymbolGroup(groups);
            this.lockGroups();
        }
    }
}

