/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.function;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.PossibleConfiguration;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.diagram.content.ElementContext;
import org.simantics.diagram.function.PredefinedVariables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.issues.common.IssueUtils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.loader.SceneGraphContext;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;

public class All {
    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable defaultRuntimeVariable(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        SceneGraphContext vc = ScenegraphLoaderUtils.getContext((ReadGraph)graph, (Variable)context);
        if (vc == null) {
            return null;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String uri = (String)graph.getRelatedValue(vc.getRuntime(), DIA.RuntimeDiagram_HasVariable, (Binding)Bindings.STRING);
        return Variables.getVariable((ReadGraph)graph, (String)uri);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String referenceText(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        String path = (String)context.getParent(graph).getPropertyValue(graph, "reference", (Binding)Bindings.STRING);
        try {
            Variable selection = ScenegraphLoaderUtils.getPossibleVariableSelection((ReadGraph)graph, (Variable)context);
            PredefinedVariables vars = PredefinedVariables.getInstance();
            Variable property = vars.getVariable(graph, path, converter, selection);
            if (property != null) {
                return property.getValue(graph).toString();
            }
        }
        catch (MissingVariableException missingVariableException) {
            return "Invalid path.";
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> ElementContext -> a")
    public static Object modelledTransform(ReadGraph graph, Resource converter, ElementContext context) throws DatabaseException {
        return graph.getRelatedValue(context.element, G2DResource.getInstance((ReadGraph)graph).HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
    }

    @SCLValue(type="ReadGraph -> Resource -> ElementContext -> a")
    public static Object flagTransform(ReadGraph graph, Resource converter, ElementContext context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        Resource flag = context.element;
        Resource runtimeDiagram = context.runtime;
        Resource diagram = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        if (diagram == null) {
            return All.flagTransformImpl(graph, converter, context);
        }
        Resource template = All.getTemplateFromDiagram(graph, diagram);
        if (template == null) {
            return All.flagTransformImpl(graph, converter, context);
        }
        double gridSize = DiagramGraphUtil.getGridSize(graph, diagram, 0.0);
        String tableName = (String)graph.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableBinding, (Binding)Bindings.STRING);
        Integer rowIndex = (Integer)graph.getPossibleRelatedValue(flag, DIA.Flag_HasIOTableRowIndex, (Binding)Bindings.INTEGER);
        Collection slotTables = graph.getObjects(template, L0.ConsistsOf);
        for (Resource slotTable : slotTables) {
            String name;
            if (!graph.isInstanceOf(slotTable, TEMPLATE2D.FlagTable) || !(name = (String)graph.getPossibleRelatedValue(slotTable, L0.HasName, (Binding)Bindings.STRING)).equals(tableName)) continue;
            double[] transform = (double[])graph.getPossibleRelatedValue2(slotTable, DIA.Scenegraph_Composite_transform, Bindings.getBindingUnchecked(double[].class));
            Resource align = graph.getPossibleObject(slotTable, TEMPLATE2D.FlagTable_HasAlignment);
            boolean isRightAlignment = false;
            if (align.equals(TEMPLATE2D.FlagTable_Alignment_Right)) {
                isRightAlignment = true;
            }
            Float width = (Float)graph.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasWidth, (Binding)Bindings.FLOAT);
            Float rowHeight = (Float)graph.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasRowHeigth, (Binding)Bindings.FLOAT);
            double[] flagTransform = (double[])graph.getRelatedValue(flag, DIA.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
            return All.calcTransform(transform, flagTransform, rowHeight, width, isRightAlignment, rowIndex, gridSize);
        }
        return All.flagTransformImpl(graph, converter, context);
    }

    private static Object flagTransformImpl(ReadGraph graph, Resource converter, ElementContext context) throws DatabaseException {
        double[] mat = (double[])graph.getRelatedValue(context.element, G2DResource.getInstance((ReadGraph)graph).HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
        return mat;
    }

    private static double[] calcTransform(double[] tableTransform, double[] flagTransform, Float rowHeight, Float tableWidth, boolean isRightAlignment, Integer flagRowIndex, double gridSize) {
        double scale = tableTransform[3];
        double scaledRowHeigth = scale * (double)rowHeight.floatValue();
        double rowMiddleY = tableTransform[5] + (double)((float)flagRowIndex.intValue() + 0.5f) * scaledRowHeigth;
        if (gridSize != 0.0) {
            double diff;
            double modulo = rowMiddleY % gridSize;
            int count = (int)(rowMiddleY / gridSize);
            double gridOnRow = modulo > gridSize / 2.0 ? gridSize * (double)(1 + count) : gridSize * (double)count;
            double d = diff = gridOnRow > rowMiddleY ? gridOnRow - rowMiddleY : rowMiddleY - gridOnRow;
            if (diff < scaledRowHeigth / 2.0) {
                rowMiddleY = gridOnRow;
            }
        }
        rowMiddleY = (rowMiddleY - tableTransform[5]) / scale;
        double xx = isRightAlignment ? (double)tableWidth.floatValue() : 0.0;
        AffineTransform trans = new AffineTransform(new double[]{tableTransform[0], tableTransform[1], tableTransform[2], tableTransform[3], 0.0, 0.0});
        Point2D.Double point = new Point2D.Double(xx, rowMiddleY);
        trans.transform(point, point);
        double[] copy = Arrays.copyOf(flagTransform, flagTransform.length);
        copy[4] = tableTransform[4] + ((Point2D)point).getX();
        copy[5] = tableTransform[5] + ((Point2D)point).getY();
        return copy;
    }

    public static Resource getTemplate(ReadGraph graph, Resource runtimeDiagram) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource diagram = graph.getPossibleObject(runtimeDiagram, DIA.RuntimeDiagram_HasConfiguration);
        if (diagram == null) {
            return null;
        }
        return All.getTemplateFromDiagram(graph, diagram);
    }

    public static Resource getTemplateFromDiagram(ReadGraph graph, Resource diagram) throws DatabaseException {
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        Resource template = graph.getPossibleObject(diagram, TEMPLATE2D.HasDrawingTemplate);
        return template;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String diagramElementIssuePath(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        List contexts = IssueUtils.getContextsForProperty((ReadGraph)graph, (Variable)property);
        if (contexts.isEmpty()) {
            return "";
        }
        Resource context = (Resource)contexts.get(0);
        Resource mapped = graph.getPossibleObject(context, MOD.ComponentToElement);
        if (mapped != null) {
            context = mapped;
        }
        if ((mapped = graph.getPossibleObject(context, MOD.ConnectionToDiagramConnection)) != null) {
            context = mapped;
        }
        if (!graph.isInstanceOf(context, DIA.Element)) {
            return "";
        }
        Resource configuration = (Resource)graph.sync((ReadInterface)new PossibleConfiguration(context));
        if (configuration == null) {
            return "";
        }
        Resource diagram = graph.getPossibleObject(context, L0.PartOf);
        if (diagram == null) {
            return "";
        }
        Resource composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
        if (composite == null) {
            return "";
        }
        Resource issueRoot = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)property);
        if (issueRoot == null) {
            return "";
        }
        Resource contextRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(composite));
        if (contextRoot == null) {
            return "";
        }
        if (issueRoot.equals(contextRoot)) {
            String uri = graph.getURI(composite);
            String modelURI = graph.getURI(contextRoot);
            return IssueUtils.pathString((String)uri, (int)(modelURI.length() + 1));
        }
        String uri = graph.getURI(composite);
        String modelURI = graph.getURI(graph.getRootLibrary());
        return IssueUtils.pathString((String)uri, (int)(modelURI.length() + 1));
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object fontModifier(ReadGraph graph, Resource r, final Variable variable) throws DatabaseException {
        return new Labeler.DialogModifier(){

            public String getValue() {
                return null;
            }

            public String isValid(String label) {
                return null;
            }

            public void modify(final String label) {
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Variable displayValue = variable.getParent((ReadGraph)graph);
                        displayValue.setValue(graph, (Object)label, (Binding)Bindings.STRING);
                    }
                });
            }

            public String query(Object parentControl, Object controlItem, int columnIndex, final NodeContext context, Consumer<String> applyCallback) {
                FontData font;
                FontData[] initialValue;
                Control ctrl;
                block8: {
                    ctrl = (Control)parentControl;
                    initialValue = null;
                    try {
                        String[] fields;
                        String font2 = (String)Simantics.getSession().syncRequest((Read)new UniqueRead<String>(){

                            public String perform(ReadGraph graph) throws DatabaseException {
                                Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)context, Variable.class);
                                if (v == null) {
                                    return null;
                                }
                                String displayValue = (String)v.getPossiblePropertyValue(graph, "HasDisplayValue", (Binding)Bindings.STRING);
                                return displayValue;
                            }
                        });
                        if (font2 == null || (fields = font2.split(",")).length != 3) break block8;
                        int size = 14;
                        try {
                            size = Integer.parseInt(fields[1]);
                        }
                        catch (NumberFormatException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                        int style = 0;
                        try {
                            style = Fonts.swtStyle((String)fields[2]);
                        }
                        catch (RuntimeException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                        initialValue = new FontData[]{new FontData(fields[0], size, style)};
                    }
                    catch (DatabaseException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
                FontDialog dialog = new FontDialog(ctrl.getShell());
                if (initialValue != null) {
                    dialog.setFontList(initialValue);
                }
                if ((font = dialog.open()) != null) {
                    applyCallback.accept(String.valueOf(font.getName()) + "," + font.getHeight() + "," + Fonts.fromSwtStyle((int)font.getStyle()));
                }
                return null;
            }
        };
    }
}

