/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.rules.IMapping;
import org.simantics.modeling.rules.Mapping;
import org.simantics.modeling.rules.RelatedDiagramConnections;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.AbstractModelingRules;
import org.simantics.structural2.modelingRules.CPConnection;
import org.simantics.structural2.modelingRules.CPConnectionJoin;
import org.simantics.structural2.modelingRules.CPIgnore;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IAttachmentRelationMap;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.structural2.modelingRules.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedModelingRules
extends AbstractModelingRules {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappedModelingRules.class);
    IModelingRules baseRules;
    IMapping mapping;

    public MappedModelingRules(IModelingRules baseRules, IMapping mapping) {
        this.baseRules = baseRules;
        this.mapping = mapping;
    }

    public MappedModelingRules(ReadGraph g, IModelingRules baseRules) throws DatabaseException {
        this(baseRules, new Mapping(g));
    }

    public boolean canPopulate(ReadGraph g, Resource componentType) throws DatabaseException {
        Resource mappedComponentType = this.mapping.mapComponentType(g, componentType);
        if (mappedComponentType == null) {
            return false;
        }
        return this.baseRules.canPopulate(g, mappedComponentType);
    }

    public void setConnectionType(WriteGraph g, Resource connection, Resource connectionType) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        if (Policy.DEBUG_STANDARD_MODELING_RULES) {
            LOGGER.info("setConnectionType(" + NameUtils.getSafeName((ReadGraph)g, (Resource)connection) + ", " + NameUtils.getSafeName((ReadGraph)g, (Resource)connectionType) + ")");
        }
        RelatedDiagramConnections rdc = new RelatedDiagramConnections((ReadGraph)g);
        rdc.addConnection(connection);
        for (Resource c : rdc.connections) {
            g.deny(c, sr.HasConnectionType);
            g.claim(c, sr.HasConnectionType, null, connectionType);
        }
        if (!rdc.outputConnectors.isEmpty()) {
            Resource requiredConnectionMappingSpecification = g.getPossibleObject(connectionType, MOD.ConnectionTypeToConnectionMappingSpecification);
            for (Resource connector : rdc.outputConnectors) {
                for (Statement connects : g.getStatements(connector, sr.Connects)) {
                    Resource cp;
                    Resource dcp;
                    if (g.isInstanceOf(connects.getObject(), DIA.Connection) || (dcp = g.getPossibleInverse(connects.getPredicate())) == null || (cp = g.getPossibleObject(dcp, MOD.DiagramConnectionRelationToConnectionRelation)) == null) continue;
                    g.deny(connector, MOD.HasConnectionMappingSpecification);
                    if (requiredConnectionMappingSpecification == null || !g.hasStatement(cp, MOD.NeedsConnectionMappingSpecification)) continue;
                    g.claim(connector, MOD.HasConnectionMappingSpecification, requiredConnectionMappingSpecification);
                }
            }
        }
    }

    private ArrayList<IConnectionPoint> getMappedConnectionPoints(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        ArrayList<IConnectionPoint> mappedConnectionPoints = new ArrayList<IConnectionPoint>(connectionPoints.size());
        for (IConnectionPoint cp : connectionPoints) {
            int mcps;
            if (cp == null) {
                throw new IllegalArgumentException("Null connection point encountered.");
            }
            if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                LOGGER.info("Mapping CP: " + cp.toString(g));
            }
            if ((mcps = this.mapping.mapToConnectionPoints(g, cp, mappedConnectionPoints)) > 0) {
                if (!Policy.DEBUG_STANDARD_MODELING_RULES) continue;
                for (IConnectionPoint mcpt : mappedConnectionPoints.subList(mappedConnectionPoints.size() - mcps, mappedConnectionPoints.size())) {
                    LOGGER.info("Mapped CP: " + mcpt.toString(g));
                }
                continue;
            }
            if (cp instanceof CPTerminal) {
                CPTerminal terminal = (CPTerminal)cp;
                DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
                if (terminal.component == null || !g.isInstanceOf(terminal.component, dr.Flag)) continue;
                if (g.hasStatement(terminal.component, dr.Flag_ConnectionPoint)) {
                    return null;
                }
                for (Resource join : g.getObjects(terminal.component, dr.FlagIsJoinedBy)) {
                    mappedConnectionPoints.add((IConnectionPoint)new CPConnectionJoin(join));
                }
                Resource isLiftedAs = g.getPossibleObject(terminal.component, dr.IsLiftedAs);
                if (isLiftedAs == null) continue;
                mappedConnectionPoints.add((IConnectionPoint)new CPTerminal(terminal.component, isLiftedAs));
                continue;
            }
            if (cp instanceof CPConnection || cp instanceof CPIgnore) continue;
            return null;
        }
        return mappedConnectionPoints;
    }

    public ConnectionJudgement judgeConnection(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        ArrayList<IConnectionPoint> mappedConnectionPoints = this.getMappedConnectionPoints(g, connectionPoints);
        if (mappedConnectionPoints == null) {
            return ConnectionJudgement.ILLEGAL;
        }
        ConnectionJudgement judgement = this.baseRules.judgeConnection(g, mappedConnectionPoints);
        if (judgement.attachmentRelations != null) {
            judgement.attachmentRelations = new MappedAttachmentRelationMap(judgement.attachmentRelations);
        }
        return judgement;
    }

    public Resource computeConnectionType(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        ArrayList<IConnectionPoint> mappedConnectionPoints = this.getMappedConnectionPoints(g, connectionPoints);
        if (mappedConnectionPoints == null) {
            return null;
        }
        return this.baseRules.computeConnectionType(g, mappedConnectionPoints);
    }

    public IAttachmentRelationMap getAttachmentRelations(ReadGraph g, Resource connection) throws DatabaseException {
        Resource mappedConnection = this.mapping.mapConnection(g, connection);
        if (mappedConnection == null) {
            LOGGER.warn("Connection mapped from " + NameUtils.getSafeName((ReadGraph)g, (Resource)connection, (boolean)true) + " is null");
        }
        return new MappedAttachmentRelationMap(this.baseRules.getAttachmentRelations(g, mappedConnection));
    }

    public Set<CPTerminal> resolveTerminals(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        HashSet<CPTerminal> terminals = new HashSet<CPTerminal>();
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        for (IConnectionPoint cp : connectionPoints) {
            if (cp instanceof CPTerminal) {
                terminals.add((CPTerminal)cp);
                continue;
            }
            if (cp instanceof CPConnection) {
                CPConnection connection = (CPConnection)cp;
                for (Resource connector : g.getObjects(connection.connection, DIA.HasConnector)) {
                    for (Statement stat : g.getStatements(connector, STR.Connects)) {
                        if (stat.getObject().equals(connection.connection)) continue;
                        terminals.add(new CPTerminal(stat.getObject(), g.getInverse(stat.getPredicate())));
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Connection point " + cp + " encountered.");
        }
        return terminals;
    }

    class MappedAttachmentRelationMap
    implements IAttachmentRelationMap {
        IAttachmentRelationMap baseMap;

        public MappedAttachmentRelationMap(IAttachmentRelationMap baseMap) {
            this.baseMap = baseMap;
        }

        public Resource get(ReadGraph g, CPTerminal cp) throws DatabaseException {
            IConnectionPoint mcp = MappedModelingRules.this.mapping.mapConnectionPoint(g, (IConnectionPoint)cp);
            if (mcp instanceof CPTerminal) {
                return this.baseMap.get(g, (CPTerminal)mcp);
            }
            return null;
        }
    }
}

