/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services.adaption;

import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.adaption.AdapterInstaller;
import org.simantics.db.adaption.AdaptionService;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.services.adaption.reflection.AdaptingDynamicAdapter2;
import org.simantics.db.services.adaption.reflection.AtMostOneRelatedResource2;
import org.simantics.db.services.adaption.reflection.ConstantAdapter;
import org.simantics.db.services.adaption.reflection.GraphObject2;
import org.simantics.db.services.adaption.reflection.IDynamicAdapter2;
import org.simantics.db.services.adaption.reflection.OrderedSetResources2;
import org.simantics.db.services.adaption.reflection.ReflectionAdapter2;
import org.simantics.db.services.adaption.reflection.RelatedResources2;
import org.simantics.db.services.adaption.reflection.SingleRelatedResource2;
import org.simantics.db.services.adaption.reflection.StaticMethodAdapter;
import org.simantics.db.services.adaption.reflection.ThisResource2;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.utils.FileUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AdapterRegistry2 {
    public static final String ADAPTERS_FILE = "adapters.xml";
    public static final String ADAPTERS = "adapters";
    public static final String ADAPTER = "adapter";
    public static final String TARGET = "target";
    public static final String BASE_TYPE = "baseType";
    public static final String TYPE = "type";
    public static final String RESOURCE = "resource";
    public static final String URI = "uri";
    public static final String INTERFACE = "interface";
    public static final String CLASS = "class";
    public static final String ADAPTER_CLASS = "adapterClass";
    public static final String CONTEXT_CLASS = "contextClass";
    public static final String INSTALLER = "installer";
    public static final String CONSTRUCTOR = "constructor";
    private static AdapterRegistry2 instance = new AdapterRegistry2();
    Collection<AdapterInstaller> installers = new ArrayList<AdapterInstaller>();
    Map<AdapterInstaller, String> installerSources = new HashMap<AdapterInstaller, String>();
    Collection<Exception> exceptions = new ArrayList<Exception>();

    public static AdapterRegistry2 getInstance() {
        return instance;
    }

    private void addInstaller(AdapterInstaller installer, String sourceDesc) {
        this.installers.add(installer);
        this.installerSources.put(installer, sourceDesc);
    }

    private void handleException(Exception e, String fileName) {
        System.err.println("At " + fileName);
        e.printStackTrace();
    }

    private void handleException(Exception e, AdapterInstaller installer) {
        String desc = this.installerSources.get(installer);
        if (desc != null) {
            System.err.println("At " + desc);
        }
        e.printStackTrace();
    }

    private void handleAdaptersDocument(Loader b, Document doc, String fileName) {
        try {
            Element node = doc.getDocumentElement();
            if (node.getNodeName().equals(ADAPTERS)) {
                NodeList nodeList = node.getChildNodes();
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node n = nodeList.item(i);
                    if (n.getNodeName().equals(TARGET)) {
                        this.handleTarget(b, n, fileName);
                    } else if (n.getNodeName().equals(INSTALLER)) {
                        this.handleInstaller(b, n, fileName);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, fileName);
        }
    }

    private void handleTarget(Loader b, Node node, String fileName) {
        try {
            Class<?> interface_ = b.loadClass(node.getAttributes().getNamedItem(INTERFACE).getNodeValue());
            NodeList nodeList = node.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node n = nodeList.item(i);
                String nodeName = n.getNodeName();
                if (nodeName.equals(BASE_TYPE)) {
                    this.handleBaseType(b, interface_, n, fileName);
                } else if (nodeName.equals(TYPE)) {
                    this.handleType(b, interface_, n, fileName);
                } else if (nodeName.equals(ADAPTER)) {
                    this.handleAdapter(b, interface_, n, fileName);
                } else if (nodeName.equals(RESOURCE)) {
                    this.handleResource(b, interface_, n, fileName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.handleException(e, fileName);
        }
    }

    private void handleInstaller(Loader b, Node node, String fileName) {
        try {
            AdapterInstaller installer = b.loadClass(node.getAttributes().getNamedItem(CLASS).getNodeValue()).asSubclass(AdapterInstaller.class).newInstance();
            this.addInstaller(installer, fileName);
        }
        catch (Exception e) {
            this.handleException(e, fileName);
        }
    }

    private <T> void handleResource(final Loader b, final Class<T> interface_, final Node node, String fileName) {
        try {
            NamedNodeMap attr = node.getAttributes();
            final String uri = attr.getNamedItem(URI).getNodeValue();
            final String className = attr.getNamedItem(CLASS).getNodeValue();
            Node constructorNode = attr.getNamedItem(CONSTRUCTOR);
            final String constructor = constructorNode == null ? null : constructorNode.getNodeValue();
            this.addInstaller(new AdapterInstaller(){

                public void install(ReadGraph g, AdaptionService service) throws Exception {
                    Class clazz = b.loadClass(className).asSubclass(interface_);
                    List parameters = AdapterRegistry2.this.readParameters(g, node, b);
                    IDynamicAdapter2[] parameterArray = parameters.toArray(new IDynamicAdapter2[parameters.size()]);
                    Resource r = g.getResource(uri);
                    service.addInstanceAdapter(r, interface_, constructor == null ? new ReflectionAdapter2(clazz, parameterArray) : new StaticMethodAdapter(clazz, constructor, parameterArray));
                }
            }, fileName);
        }
        catch (Exception e) {
            this.handleException(e, fileName);
        }
    }

    private <T> void handleType(final Loader b, final Class<T> interface_, final Node node, String fileName) {
        try {
            final NamedNodeMap attr = node.getAttributes();
            final String uri = attr.getNamedItem(URI).getNodeValue();
            Node constructorNode = attr.getNamedItem(CONSTRUCTOR);
            final String constructor = constructorNode == null ? null : constructorNode.getNodeValue();
            this.addInstaller(new AdapterInstaller(){

                public void install(ReadGraph g, AdaptionService service) throws Exception {
                    try {
                        Class clazz = b.loadClass(attr.getNamedItem(AdapterRegistry2.CLASS).getNodeValue()).asSubclass(interface_);
                        List parameters = AdapterRegistry2.this.readParameters(g, node, b);
                        IDynamicAdapter2[] parameterArray = parameters.toArray(new IDynamicAdapter2[parameters.size()]);
                        service.addAdapter(g.getResource(uri), interface_, constructor == null ? new ReflectionAdapter2(clazz, parameterArray) : new StaticMethodAdapter(clazz, constructor, parameterArray));
                    }
                    catch (Error t) {
                        System.err.println("Failed to adapt " + interface_.getName());
                        throw t;
                    }
                    catch (RuntimeException t) {
                        System.err.println("Failed to adapt " + interface_.getName());
                        throw t;
                    }
                }
            }, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(e, fileName);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<IDynamicAdapter2> readParameters(ReadGraph g, Node node, Loader b) throws DatabaseException, DOMException, ClassNotFoundException {
        NodeList nodeList = node.getChildNodes();
        ArrayList<IDynamicAdapter2> parameters = new ArrayList<IDynamicAdapter2>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node n = nodeList.item(i);
            if (n.getNodeType() == 1) {
                void var9_9;
                NamedNodeMap attr = n.getAttributes();
                Object var9_10 = null;
                if (n.getNodeName().equals("this")) {
                    ThisResource2 thisResource2 = new ThisResource2();
                } else if (n.getNodeName().equals("graph")) {
                    GraphObject2 graphObject2 = new GraphObject2();
                } else if (n.getNodeName().equals("bundle")) {
                    String bundleId = null;
                    Node fc = n.getFirstChild();
                    if (fc != null) {
                        bundleId = fc.getNodeValue();
                    }
                    if (bundleId == null) {
                        ConstantAdapter constantAdapter = new ConstantAdapter(Bundle.class, b.getBundle());
                    } else {
                        Bundle ob = Platform.getBundle((String)bundleId);
                        if (ob == null) throw new DOMException(8, "bundle '" + bundleId + "' not found");
                        ConstantAdapter constantAdapter = new ConstantAdapter(Bundle.class, ob);
                    }
                } else if (n.getNodeName().equals("related")) {
                    RelatedResources2 relatedResources2 = new RelatedResources2(g.getResource(attr.getNamedItem(URI).getNodeValue()));
                } else if (n.getNodeName().equals("orderedSet")) {
                    OrderedSetResources2 orderedSetResources2 = new OrderedSetResources2(g.getResource(attr.getNamedItem(URI).getNodeValue()));
                } else if (n.getNodeName().equals("single")) {
                    SingleRelatedResource2 singleRelatedResource2 = new SingleRelatedResource2(g.getResource(attr.getNamedItem(URI).getNodeValue()));
                } else if (n.getNodeName().equals("atMostOne")) {
                    AtMostOneRelatedResource2 atMostOneRelatedResource2 = new AtMostOneRelatedResource2(g.getResource(attr.getNamedItem(URI).getNodeValue()));
                } else if (n.getNodeName().equals("string")) {
                    ConstantAdapter constantAdapter = new ConstantAdapter(String.class, n.getFirstChild().getNodeValue());
                }
                Node toNode = attr.getNamedItem("to");
                if (toNode != null) {
                    void var9_20;
                    String to = toNode.getNodeValue();
                    AdaptingDynamicAdapter2 adaptingDynamicAdapter2 = new AdaptingDynamicAdapter2((IDynamicAdapter2)var9_20, b.loadClass(to));
                }
                parameters.add((IDynamicAdapter2)var9_9);
            }
            ++i;
        }
        return parameters;
    }

    private <T> void handleAdapter(final Loader b, final Class<T> interface_, Node node, String fileName) {
        try {
            NamedNodeMap attr = node.getAttributes();
            final String uri = attr.getNamedItem(URI).getNodeValue();
            final String clazz = attr.getNamedItem(ADAPTER_CLASS).getNodeValue();
            Node contextNode = attr.getNamedItem(CONTEXT_CLASS);
            final Class<Resource> contextClass = contextNode != null ? b.loadClass(contextNode.getNodeValue()) : Resource.class;
            this.addInstaller(new AdapterInstaller(){

                public void install(ReadGraph g, AdaptionService service) throws Exception {
                    service.addAdapter(g.getResource(uri), interface_, contextClass, b.loadClass(clazz).asSubclass(Adapter.class).newInstance());
                }
            }, fileName);
        }
        catch (Exception e) {
            this.handleException(e, fileName);
        }
    }

    private <T> void handleBaseType(Loader b, final Class<T> interface_, Node node, String fileName) {
        try {
            NamedNodeMap attr = node.getAttributes();
            final String uri = attr.getNamedItem(URI).getNodeValue();
            this.addInstaller(new AdapterInstaller(){

                public void install(ReadGraph g, AdaptionService service) throws Exception {
                    service.declareAdapter(g.getResource(uri), interface_);
                }
            }, fileName);
        }
        catch (Exception e) {
            this.handleException(e, fileName);
        }
    }

    public void updateAdaptionService(Session s, final AdaptionService service) throws DatabaseException {
        s.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) {
                for (AdapterInstaller t : AdapterRegistry2.this.installers) {
                    try {
                        t.install(g, service);
                    }
                    catch (Exception e) {
                        AdapterRegistry2.this.handleException(e, t);
                    }
                }
            }
        });
    }

    public void initialize(ClassLoader b, String schemaURL, File[] files) {
        block6: {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                if (schemaURL != null && this.validateAgainstSchema()) {
                    factory.setValidating(true);
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaURL);
                }
                if (!this.exceptions.isEmpty()) break block6;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    final File f = fileArray[n2];
                    try {
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        builder.setErrorHandler(new ErrorHandler(){

                            @Override
                            public void error(SAXParseException exception) throws SAXException {
                                System.err.println("Parse error at " + f.getAbsolutePath() + " line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ":");
                                System.err.println(exception.getMessage());
                            }

                            @Override
                            public void fatalError(SAXParseException exception) throws SAXException {
                                this.error(exception);
                            }

                            @Override
                            public void warning(SAXParseException exception) throws SAXException {
                                this.error(exception);
                            }
                        });
                        Document doc = builder.parse(f);
                        this.handleAdaptersDocument(this.loader(b), doc, f.getAbsolutePath());
                    }
                    catch (Exception e) {
                        this.handleException(e, f.getAbsolutePath());
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                this.handleException(e, "(no file name available)");
            }
        }
    }

    private boolean validateAgainstSchema() {
        return Platform.inDevelopmentMode();
    }

    public void initialize(BundleContext context) {
        block7: {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                if (this.validateAgainstSchema()) {
                    factory.setValidating(true);
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", context.getBundle().getResource("adapters.xsd").toString());
                }
                if (!this.exceptions.isEmpty()) break block7;
                Bundle[] bundleArray = context.getBundles();
                int n = bundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final Bundle b = bundleArray[n2];
                    URL file = b.getEntry(ADAPTERS_FILE);
                    if (file != null) {
                        String fileName = new Path(b.getLocation()).append(file.getPath()).toString();
                        try {
                            DocumentBuilder builder = factory.newDocumentBuilder();
                            builder.setErrorHandler(new ErrorHandler(){

                                @Override
                                public void error(SAXParseException exception) throws SAXException {
                                    System.err.println("Parse error at " + b.getSymbolicName() + "/adapters.xml" + " line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ":");
                                    System.err.println(exception.getMessage());
                                }

                                @Override
                                public void fatalError(SAXParseException exception) throws SAXException {
                                    this.error(exception);
                                }

                                @Override
                                public void warning(SAXParseException exception) throws SAXException {
                                    this.error(exception);
                                }
                            });
                            String text = FileUtils.getContents((URL)file);
                            text = OntologyVersions.getInstance().currentVersion(text);
                            StringReader reader = new StringReader(text);
                            InputSource inputSource = new InputSource(reader);
                            Document doc = builder.parse(inputSource);
                            reader.close();
                            this.handleAdaptersDocument(this.loader(b), doc, fileName);
                        }
                        catch (Exception e) {
                            this.handleException(e, fileName);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                this.handleException(e, "(no file name available)");
            }
        }
    }

    private Loader loader(final Bundle b) {
        return new Loader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return b.loadClass(name);
            }

            @Override
            public Bundle getBundle() {
                return b;
            }
        };
    }

    private Loader loader(final ClassLoader b) {
        return new Loader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return b.loadClass(name);
            }

            @Override
            public Bundle getBundle() {
                return null;
            }
        };
    }

    static interface Loader {
        public Class<?> loadClass(String var1) throws ClassNotFoundException;

        public Bundle getBundle();
    }
}

