/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.internal;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.internal.IGECache;
import org.simantics.browsing.ui.common.internal.UIElementReference;

public class GECache
implements IGECache {
    final Map<GECacheKey, IGECache.IGECacheEntry> entries = new THashMap();
    final Map<GECacheKey, Set<UIElementReference>> treeReferences = new THashMap();
    NodeContext getNC = new NodeContext(){

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public <T> T getConstant(NodeContext.ConstantKey<T> key) {
            return null;
        }

        public Set<NodeContext.ConstantKey<?>> getKeys() {
            return Collections.emptySet();
        }
    };
    NodeContext.CacheKey<?> getCK = new NodeContext.CacheKey<Object>(){

        public Object processorIdenfitier() {
            return this;
        }
    };
    GECacheKey getKey = new GECacheKey(this.getNC, this.getCK);
    private TObjectIntHashMap<NodeContext> references = new TObjectIntHashMap();

    @Override
    public <T> IGECache.IGECacheEntry put(NodeContext context, NodeContext.CacheKey<T> key, T value) {
        IGECache.GECacheEntry entry = new IGECache.GECacheEntry(context, key, value);
        this.entries.put(new GECacheKey(context, key), entry);
        return entry;
    }

    @Override
    public <T> T get(NodeContext context, NodeContext.CacheKey<T> key) {
        this.getKey.setValues(context, key);
        IGECache.IGECacheEntry entry = this.entries.get(this.getKey);
        if (entry == null) {
            return null;
        }
        return (T)entry.getValue();
    }

    @Override
    public <T> IGECache.IGECacheEntry getEntry(NodeContext context, NodeContext.CacheKey<T> key) {
        assert (context != null);
        assert (key != null);
        this.getKey.setValues(context, key);
        return this.entries.get(this.getKey);
    }

    @Override
    public <T> void remove(NodeContext context, NodeContext.CacheKey<T> key) {
        this.getKey.setValues(context, key);
        this.entries.remove(this.getKey);
    }

    @Override
    public <T> Set<UIElementReference> getTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
        assert (context != null);
        assert (key != null);
        this.getKey.setValues(context, key);
        return this.treeReferences.get(this.getKey);
    }

    @Override
    public <T> void putTreeReference(NodeContext context, NodeContext.CacheKey<T> key, UIElementReference reference) {
        assert (context != null);
        assert (key != null);
        this.getKey.setValues(context, key);
        THashSet refs = this.treeReferences.get(this.getKey);
        if (refs != null) {
            refs.add((UIElementReference)reference);
        } else {
            refs = new THashSet(4);
            refs.add(reference);
            this.treeReferences.put(new GECacheKey(this.getKey), (Set<UIElementReference>)refs);
        }
    }

    @Override
    public <T> Set<UIElementReference> removeTreeReference(NodeContext context, NodeContext.CacheKey<T> key) {
        assert (context != null);
        assert (key != null);
        this.getKey.setValues(context, key);
        return this.treeReferences.remove(this.getKey);
    }

    @Override
    public boolean isShown(NodeContext context) {
        return this.references.get((Object)context) > 0;
    }

    @Override
    public void incRef(NodeContext context) {
        int exist = this.references.get((Object)context);
        this.references.put((Object)context, exist + 1);
    }

    @Override
    public void decRef(NodeContext context) {
        int exist = this.references.get((Object)context);
        this.references.put((Object)context, exist - 1);
        if (exist == 1) {
            this.references.remove((Object)context);
        }
    }

    @Override
    public void dispose() {
        this.references.clear();
        this.entries.clear();
        this.treeReferences.clear();
    }

    private static final class GECacheKey {
        private NodeContext context;
        private NodeContext.CacheKey<?> key;

        GECacheKey(NodeContext context, NodeContext.CacheKey<?> key) {
            this.context = context;
            this.key = key;
            if (context == null || key == null) {
                throw new IllegalArgumentException("Null context or key is not accepted");
            }
        }

        GECacheKey(GECacheKey other) {
            this.context = other.context;
            this.key = other.key;
            if (this.context == null || this.key == null) {
                throw new IllegalArgumentException("Null context or key is not accepted");
            }
        }

        void setValues(NodeContext context, NodeContext.CacheKey<?> key) {
            this.context = context;
            this.key = key;
            if (context == null || key == null) {
                throw new IllegalArgumentException("Null context or key is not accepted");
            }
        }

        public int hashCode() {
            return this.context.hashCode() | this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            GECacheKey i = (GECacheKey)object;
            return this.key.equals(i.key) && this.context.equals(i.context);
        }
    }
}

