/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads;

import java.util.concurrent.TimeUnit;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class Throttler
implements Runnable {
    private final IThreadWorkQueue thread;
    private final int interval;
    private boolean isScheduling = false;
    private long[] dispatchTimes;
    private long lastQueueTime;
    private int dispatchTimePointer = 0;
    private Runnable todo;

    public Throttler(IThreadWorkQueue thread, int interval, int queueLength) {
        this.thread = thread;
        this.interval = interval;
        long currentTime = System.currentTimeMillis();
        this.dispatchTimes = new long[queueLength];
        int i = 0;
        while (i < this.dispatchTimes.length) {
            this.dispatchTimes[i] = currentTime - (long)interval;
            ++i;
        }
        this.lastQueueTime = Long.MAX_VALUE;
    }

    @Override
    public synchronized void run() {
        if (this.todo != null) {
            this.thread.asyncExec(this.todo);
            this.todo = null;
            ThreadUtils.getTimer().schedule(this, (long)this.interval, TimeUnit.MILLISECONDS);
        } else {
            this.isScheduling = false;
        }
    }

    public synchronized void schedule(Runnable r) {
        assert (this.thread.currentThreadAccess());
        this.dispatch(r);
        if (this.getQueueTime() < (long)this.interval) {
            this.isScheduling = true;
            ThreadUtils.getTimer().schedule(this, (long)this.interval, TimeUnit.MILLISECONDS);
        }
    }

    private long getQueueTime() {
        return this.lastQueueTime;
    }

    private void dispatch(Runnable runnable) {
        long time = System.currentTimeMillis();
        this.lastQueueTime = time - this.dispatchTimes[this.dispatchTimePointer];
        this.dispatchTimes[this.dispatchTimePointer] = time;
        this.dispatchTimePointer = (this.dispatchTimePointer + 1) % this.dispatchTimes.length;
        if (!this.isScheduling) {
            this.todo = null;
            runnable.run();
        } else {
            this.todo = runnable;
        }
    }
}

