/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.query.FlagTypeFilter;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;

public class FlagTypeFilters
extends ResourceRead<List<FlagTypeFilter>> {
    public FlagTypeFilters(Resource visual) {
        super(visual);
    }

    public List<FlagTypeFilter> perform(ReadGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
        Collection filters = (Collection)g.syncRequest((Read)new ObjectsWithType(this.resource, L0.ConsistsOf, TEMPLATE2D.FlagTypeVisual_Filter));
        if (filters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FlagTypeFilter> result = new ArrayList<FlagTypeFilter>(filters.size());
        for (Resource node : filters) {
            String reference = (String)g.getPossibleRelatedValue2(node, TEMPLATE2D.FlagTypeVisual_Filter_HasProperty, (Binding)Bindings.STRING);
            String pattern = (String)g.getPossibleRelatedValue2(node, TEMPLATE2D.FlagTypeVisual_Filter_HasPattern, (Binding)Bindings.STRING);
            Boolean matchRequired = (Boolean)g.getPossibleRelatedValue2(node, TEMPLATE2D.FlagTypeVisual_Filter_matchRequired, (Binding)Bindings.BOOLEAN);
            result.add(new FlagTypeFilter(node, reference, pattern, matchRequired));
        }
        return result;
    }
}

