/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.OrderedSet;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.AbstractStringModifier;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.binaryPredicates.OrderedSetElementsPredicate;

public final class FlagLabelModifier
extends AbstractStringModifier {
    private Resource ownerFlag;
    private Resource relation;
    private Resource property;
    private Collection<Resource> diagrams = Collections.emptySet();
    private Set<String> originalLabels = new HashSet<String>();
    private Set<String> labelsInUse = Collections.emptySet();

    public FlagLabelModifier(ReadGraph graph, Resource flag, Resource relation, Resource label) throws DatabaseException {
        super(label);
        this.ownerFlag = flag;
        this.relation = relation;
        this.property = label;
        this.initialize(graph);
    }

    private void initialize(ReadGraph graph) throws DatabaseException {
        if (this.ownerFlag != null) {
            this.diagrams = OrderedSetElementsPredicate.INSTANCE.getSubjects(graph, this.ownerFlag);
            Resource correspondence = FlagUtil.getPossibleCounterpart(graph, this.ownerFlag);
            this.addPossibleLabel(graph, this.ownerFlag, this.originalLabels);
            if (correspondence != null) {
                this.addPossibleLabel(graph, correspondence, this.originalLabels);
            }
        }
        this.refreshUsedLabels(graph);
    }

    private void addPossibleLabel(ReadGraph graph, Resource flag, Set<String> result) throws DatabaseException {
        String label = (String)graph.getPossibleRelatedValue(flag, Layer0.getInstance((ReadGraph)graph).HasLabel, (Binding)Bindings.STRING);
        if (label != null && !label.isEmpty()) {
            result.add(label);
        }
    }

    private void refreshUsedLabels(ReadGraph graph) throws DatabaseException {
        HashSet<String> used = new HashSet<String>();
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource diagram : this.diagrams) {
            for (Resource element : graph.syncRequest((AsyncMultiRead)new OrderedSet(diagram))) {
                if (!graph.isInstanceOf(element, DIA.Flag)) continue;
                this.addPossibleLabel(graph, element, used);
            }
        }
        used.removeAll(this.originalLabels);
        this.labelsInUse = used;
    }

    public String isValid(String value) {
        if (this.diagrams.isEmpty() || this.ownerFlag == null) {
            return null;
        }
        if (this.labelsInUse.contains(value)) {
            return "Label is already in use on the same diagram";
        }
        return null;
    }

    public final void modify(WriteGraph graph, String value) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(this.ownerFlag, this.relation, DIA.FlagLabel, (Object)value, (Binding)Bindings.STRING);
        Resource counterpart = FlagUtil.getPossibleCounterpart((ReadGraph)graph, this.ownerFlag);
        if (counterpart != null) {
            graph.claimLiteral(counterpart, this.relation, DIA.FlagLabel, (Object)value, (Binding)Bindings.STRING);
        }
    }
}

