/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events.adapter;

import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.function.UnaryOperator;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.adapter.AbstractEventAdapter;

public class AWTMouseEventAdapter
extends AbstractEventAdapter
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final boolean DEBUG = false;
    private final boolean IGNORE_CONSUMED_EVENTS = false;
    public static final int MOUSE_ID = 0;
    private final long[] pressTime = new long[5];
    int buttonStatus = 0;

    public AWTMouseEventAdapter(Object sender, IEventHandler delegator) {
        super(sender, delegator);
    }

    public AWTMouseEventAdapter(Object sender, IEventQueue queue) {
        super(sender, queue);
    }

    public static Point2D getControlPosition(MouseEvent e) {
        return new Point2D.Double(e.getX(), e.getY());
    }

    public static Point2D getScreenPosition(MouseEvent e) {
        return e.getLocationOnScreen();
    }

    public static int getStateMask(MouseEvent e) {
        int modifiers = e.getModifiersEx();
        int stateMask = 0;
        if ((modifiers & 0x80) != 0) {
            stateMask |= 0x80;
        }
        if ((modifiers & 0x200) != 0) {
            stateMask |= 0x200;
        }
        if ((modifiers & 0x2000) != 0) {
            stateMask |= 0x2000;
        }
        if ((modifiers & 0x40) != 0) {
            stateMask |= 0x40;
        }
        return stateMask;
    }

    public static int getMouseButton(MouseEvent e) {
        int awtMouseButton = e.getButton();
        if (awtMouseButton == 1) {
            return 1;
        }
        if (awtMouseButton == 2) {
            return 3;
        }
        if (awtMouseButton == 3) {
            return 2;
        }
        return awtMouseButton;
    }

    public static int getButtonStatus(MouseEvent e) {
        int modex = e.getModifiersEx();
        int status = 0;
        status |= (modex & 0x400) != 0 ? 1 : 0;
        status |= (modex & 0x800) != 0 ? 4 : 0;
        return status |= (modex & 0x1000) != 0 ? 2 : 0;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.buttonStatus = AWTMouseEventAdapter.getButtonStatus(e);
        MouseEvent.MouseEnterEvent me = new MouseEvent.MouseEnterEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTMouseEventAdapter.getStateMask(e), AWTMouseEventAdapter.getControlPosition(e), AWTMouseEventAdapter.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        MouseEvent.MouseExitEvent me = new MouseEvent.MouseExitEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTMouseEventAdapter.getStateMask(e), AWTMouseEventAdapter.getControlPosition(e), AWTMouseEventAdapter.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int mouseButton = AWTMouseEventAdapter.getMouseButton(e);
        if (mouseButton == 0) {
            return;
        }
        if (mouseButton <= this.pressTime.length) {
            this.pressTime[mouseButton - 1] = e.getWhen();
        }
        this.buttonStatus |= 1 << mouseButton - 1;
        this.handleEvent(new MouseEvent.MouseButtonPressedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTMouseEventAdapter.getStateMask(e), mouseButton, AWTMouseEventAdapter.getControlPosition(e), AWTMouseEventAdapter.getScreenPosition(e)));
        if (e.getClickCount() == 2) {
            this.handleEvent(new MouseEvent.MouseDoubleClickedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTMouseEventAdapter.getStateMask(e), mouseButton, AWTMouseEventAdapter.getControlPosition(e), AWTMouseEventAdapter.getScreenPosition(e)));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int mouseButton = AWTMouseEventAdapter.getMouseButton(e);
        if (mouseButton == 0) {
            return;
        }
        long holdTime = Long.MAX_VALUE;
        if (mouseButton <= this.pressTime.length) {
            holdTime = e.getWhen() - this.pressTime[mouseButton - 1];
        }
        int stateMask = AWTMouseEventAdapter.getStateMask(e);
        if (mouseButton == 3) {
            stateMask &= 0xFFFFFDFF;
        }
        this.buttonStatus &= ~(1 << mouseButton - 1);
        MouseEvent.MouseButtonReleasedEvent me = new MouseEvent.MouseButtonReleasedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, stateMask, mouseButton, holdTime, AWTMouseEventAdapter.getControlPosition(e), AWTMouseEventAdapter.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        MouseEvent.MouseMovedEvent me = new MouseEvent.MouseMovedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTMouseEventAdapter.getStateMask(e), AWTMouseEventAdapter.getControlPosition(e), AWTMouseEventAdapter.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MouseEvent.MouseMovedEvent me = new MouseEvent.MouseMovedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTMouseEventAdapter.getStateMask(e), AWTMouseEventAdapter.getControlPosition(e), AWTMouseEventAdapter.getScreenPosition(e));
        this.handleEvent(me);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int wheelRotation = 0;
        wheelRotation = e.getScrollType() == 0 ? -e.getUnitsToScroll() : -e.getWheelRotation();
        this.handleEvent(new MouseEvent.MouseWheelMovedEvent(this.sender, e.getWhen(), 0, this.buttonStatus, AWTMouseEventAdapter.getStateMask(e), AWTMouseEventAdapter.getControlPosition(e), AWTMouseEventAdapter.getScreenPosition(e), e.getScrollType(), e.getScrollAmount(), wheelRotation));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void initDragGestureListener(Component rootPane, final UnaryOperator<Point2D> controlToCanvas) {
        final DragSource ds = new DragSource();
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                InputEvent ie = dge.getTriggerEvent();
                if (ie instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)ie;
                    Point2D controlPos = AWTMouseEventAdapter.getControlPosition(e);
                    Point2D canvasPos = (Point2D)controlToCanvas.apply(controlPos);
                    MouseEvent.MouseDragBegin event = new MouseEvent.MouseDragBegin(this, e.getWhen(), 0, AWTMouseEventAdapter.getButtonStatus(e), AWTMouseEventAdapter.getStateMask(e), AWTMouseEventAdapter.getMouseButton(e), canvasPos, controlPos, controlPos, AWTMouseEventAdapter.getScreenPosition(e));
                    AWTMouseEventAdapter.this.syncHandleEvent(event);
                    if (event.transferable != null) {
                        ds.startDrag(dge, null, event.transferable, null);
                    }
                }
            }
        };
        ds.createDefaultDragGestureRecognizer(rootPane, 0x40000003, dgl);
    }
}

