/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.dnd;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MultiTransferable
implements Transferable,
ClipboardOwner {
    Map<DataFlavor, Transferable> transferables = new HashMap<DataFlavor, Transferable>();

    public MultiTransferable(Transferable ... tr) {
        Transferable[] transferableArray = tr;
        int n = tr.length;
        int n2 = 0;
        while (n2 < n) {
            Transferable t = transferableArray[n2];
            DataFlavor[] dataFlavorArray = t.getTransferDataFlavors();
            int n3 = dataFlavorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                DataFlavor f = dataFlavorArray[n4];
                this.transferables.put(f, t);
                ++n4;
            }
            ++n2;
        }
    }

    public MultiTransferable(Collection<Transferable> tr) {
        for (Transferable t : tr) {
            DataFlavor[] dataFlavorArray = t.getTransferDataFlavors();
            int n = dataFlavorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor f = dataFlavorArray[n2];
                this.transferables.put(f, t);
                ++n2;
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
        for (Transferable t : this.transferables.values()) {
            if (!(t instanceof ClipboardOwner)) continue;
            ((ClipboardOwner)((Object)t)).lostOwnership(arg0, arg1);
        }
    }

    @Override
    public Object getTransferData(DataFlavor arg0) throws UnsupportedFlavorException, IOException {
        Transferable t = this.transferables.get(arg0);
        if (t == null) {
            return t;
        }
        return t.getTransferData(arg0);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.transferables.keySet().toArray(new DataFlavor[this.transferables.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor arg0) {
        return this.transferables.containsKey(arg0);
    }

    public String toString() {
        return "MultiTransferable " + this.transferables.toString();
    }
}

