/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.NoRepConstant;
import org.simantics.scl.compiler.elaboration.chr.CHRQuery;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanContext;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanOp;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanRealizer;
import org.simantics.scl.compiler.elaboration.chr.planning.QueryPlanningContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class ECHRSelect
extends Expression {
    public CHRQuery query;
    public Variable[] existentialVariables;
    public Expression expression;
    private ArrayList<PlanOp> planOps;
    private CHRRuleset currentRuleset;

    public ECHRSelect(Expression expression, CHRQuery query) {
        this.expression = expression;
        this.query = query;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.list(this.expression.getType()));
    }

    @Override
    public Expression inferType(TypingContext context) {
        Variable[] variableArray = this.existentialVariables;
        int n = this.existentialVariables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variable.setType(Types.metaVar(Kinds.STAR));
            ++n2;
        }
        this.query.checkType(context);
        this.expression = this.expression.inferType(context);
        return this;
    }

    @Override
    public Expression simplify(SimplificationContext simplificationContext) {
        this.expression = this.expression.simplify(simplificationContext);
        this.query.simplify(simplificationContext);
        return this;
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        QueryPlanningContext queryContext = new QueryPlanningContext(context, this.existentialVariables);
        if (this.query.createQueryPlan(queryContext, null, -1, null)) {
            this.planOps = queryContext.getPlanOps();
        }
        final IVal list = w.apply(this.location, context.getValue(Names.MList_create).getValue(), NoRepConstant.UNIT);
        this.planOps.add(new PlanOp(this.location){

            @Override
            public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
                w.apply(this.location, context.getValue(Names.MList_add).getValue(), list, ECHRSelect.this.expression.toVal(context, w));
            }
        });
        PlanRealizer realizer = new PlanRealizer(context, this.currentRuleset, this.currentRuleset != null ? this.currentRuleset.runtimeRulesetVariable : null, null, this.planOps);
        realizer.nextOp(w);
        return w.apply(this.location, context.getValue(Names.MList_freeze).getValue(), list);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.currentRuleset = context.currentRuleset;
        context.pushExistentialFrame();
        this.query.resolve(context);
        context.disallowNewExistentials();
        this.expression = this.expression.resolve(context);
        this.existentialVariables = context.popExistentialFrame();
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.query.setLocationDeep(loc);
            this.expression.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Variable[] newExistentialVariables = new Variable[this.existentialVariables.length];
        int i = 0;
        while (i < this.existentialVariables.length) {
            Variable newVariable = this.existentialVariables[i].copy();
            context.varMap.put((Object)this.existentialVariables[i], (Object)new EVariable(newVariable));
            newExistentialVariables[i] = newVariable;
            ++i;
        }
        ECHRSelect copy = new ECHRSelect(this.expression.replace(context), this.query.replace(context));
        copy.existentialVariables = newExistentialVariables;
        copy.currentRuleset = this.currentRuleset;
        copy.planOps = this.planOps;
        if (this.planOps != null) {
            copy.planOps = new ArrayList(this.planOps.size());
            throw new InternalCompilerError(this.location, "Copying of ECHRSelect is not supported.");
        }
        return copy;
    }
}

