/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EAsPattern
extends Expression {
    public Variable var;
    public EVar eVar;
    public Expression pattern;

    public EAsPattern(EVar eVar, Expression pattern) {
        this.eVar = eVar;
        this.pattern = pattern;
    }

    public EAsPattern(Variable var, Expression pattern) {
        this.var = var;
        this.pattern = pattern;
    }

    public Variable getVariable() {
        return this.var;
    }

    public Expression getPattern() {
        return this.pattern;
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.pattern = this.pattern.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.getErrorLog().log(this.location, "As binding (@) can be used only in patterns.");
        return this;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        this.var = context.newVariable(this.eVar.name);
        this.pattern = this.pattern.resolveAsPattern(context);
        return this;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.pattern.getType());
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        throw new InternalCompilerError("EAsPattern allowed only in patterns.");
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.pattern = this.pattern.inferType(context);
        this.var.setType(this.pattern.getType());
        return this;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.pattern = this.pattern.checkBasicType(context, requiredType);
        this.var.setType(this.pattern.getType());
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        if (!context.inPattern) {
            throw new IllegalStateException();
        }
        Variable newVariable = new Variable(this.var.name);
        newVariable.setType(this.var.getType().replace(context.tvarMap));
        context.varMap.put((Object)this.var, (Object)new EVariable(newVariable));
        EAsPattern result = new EAsPattern(this.eVar, this.pattern.replace(context));
        result.var = newVariable;
        return result;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.pattern.setLocationDeep(loc);
            if (this.eVar != null) {
                this.eVar.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

