/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.cache;

import java.lang.ref.WeakReference;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.cache.ProvisionException;

public class WeakCachedProvider<V>
implements IProvider<V> {
    IProvider<V> provider;
    WeakReference<V> ref;

    public static final <V> IProvider<V> cache(IProvider<V> provider) {
        if (provider instanceof WeakCachedProvider) {
            return provider;
        }
        return new WeakCachedProvider<V>(provider);
    }

    WeakCachedProvider(IProvider<V> orig) {
        this.provider = orig;
    }

    @Override
    public synchronized V get() throws ProvisionException {
        Object x;
        if (this.ref != null) {
            x = this.ref.get();
            if (x == null) {
                this.ref = null;
            } else {
                return (V)x;
            }
        }
        x = this.provider.get();
        this.ref = new WeakReference(x);
        return (V)x;
    }

    public int hashCode() {
        return this.provider.hashCode();
    }

    public boolean equals(Object obj) {
        return this.provider.equals(obj);
    }
}

