/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.simantics.utils.datastructures.cache.IMapProvider;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;

public class CachedMapProvider<K, V>
extends AbstractDisposable
implements IMapProvider<K, V> {
    private Map<K, V> cache;
    private final IMapProvider<K, V> provider;

    public CachedMapProvider(IMapProvider<K, V> provider) {
        assert (provider != null);
        this.provider = provider;
        this.cache = new HashMap();
    }

    public CachedMapProvider(IMapProvider<K, V> provider, Map<K, V> cacheMap) {
        assert (provider != null);
        this.provider = provider;
        this.cache = cacheMap;
    }

    @Override
    public synchronized V get(K key) {
        this.assertNotDisposed();
        V value = this.cache.get(key);
        if (value != null) {
            return value;
        }
        value = this.provider.get(key);
        assert (value != null);
        this.cache.put(key, value);
        return value;
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized void retain(Set<K> keys) {
        this.cache.keySet().retainAll(keys);
    }

    public synchronized void remove(Set<K> keys) {
        this.cache.keySet().removeAll(keys);
    }

    public synchronized void load(Set<K> keys) {
        for (K key : keys) {
            this.get(key);
        }
    }

    public synchronized void addAll(CachedMapProvider<K, V> anotherCache) {
        this.assertNotDisposed();
        this.cache.putAll(anotherCache.cache);
    }

    public IMapProvider<K, V> getProvider() {
        return this.provider;
    }

    public synchronized Map<K, V> getAll() {
        this.assertNotDisposed();
        return new HashMap<K, V>(this.cache);
    }

    @Override
    protected void doDispose() {
        this.clear();
    }
}

