/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BijectionMap<L, R> {
    private final Map<L, R> tableLeft = new HashMap<L, R>();
    private final Map<R, L> tableRight = new HashMap<R, L>();

    public boolean containsLeft(L leftValue) {
        return this.tableLeft.containsKey(leftValue);
    }

    public boolean containsRight(R rightValue) {
        return this.tableRight.containsKey(rightValue);
    }

    public void map(L leftValue, R rightValue) {
        R oldRight = this.tableLeft.remove(leftValue);
        if (oldRight != null) {
            this.tableRight.remove(oldRight);
        } else {
            L oldLeft = this.tableRight.remove(rightValue);
            if (oldLeft != null) {
                this.tableLeft.remove(oldLeft);
            }
        }
        this.tableLeft.put(leftValue, rightValue);
        this.tableRight.put(rightValue, leftValue);
    }

    public int size() {
        return this.tableLeft.size();
    }

    public L getLeft(R rightValue) {
        return this.tableRight.get(rightValue);
    }

    public R getRight(L leftValue) {
        return this.tableLeft.get(leftValue);
    }

    public R removeWithLeft(L leftValue) {
        R rightValue = this.tableLeft.remove(leftValue);
        if (rightValue != null) {
            this.tableRight.remove(rightValue);
        }
        return rightValue;
    }

    public L removeWithRight(R rightValue) {
        L leftValue = this.tableRight.remove(rightValue);
        if (leftValue != null) {
            this.tableLeft.remove(leftValue);
        }
        return leftValue;
    }

    public Set<L> getLeftSet() {
        return this.tableLeft.keySet();
    }

    public Set<R> getRightSet() {
        return this.tableRight.keySet();
    }

    public void clear() {
        this.tableLeft.clear();
        this.tableRight.clear();
    }
}

