/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.procedure.single;

import java.util.Collection;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;

public abstract class StagedSingleSetSyncListener<T>
implements SyncListener<Collection<T>> {
    private Collection<T> previous = null;

    public void start(ReadGraph graph, Collection<T> items) throws DatabaseException {
    }

    public void add(ReadGraph graph, T item) throws DatabaseException {
    }

    public void remove(ReadGraph graph, T item) throws DatabaseException {
    }

    public synchronized void execute(ReadGraph graph, Collection<T> result) throws DatabaseException {
        if (this.previous == null) {
            this.start(graph, result);
        } else {
            HashSet<T> added = new HashSet<T>(result);
            added.removeAll(this.previous);
            HashSet<T> removed = new HashSet<T>(this.previous);
            removed.removeAll(result);
            for (T t : added) {
                this.add(graph, t);
            }
            for (T t : removed) {
                this.remove(graph, t);
            }
        }
        this.previous = result;
    }

    public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
        Logger.defaultLogError(throwable);
    }
}

