/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.FileCache;
import org.simantics.acorn.MainProgram;
import org.simantics.acorn.UndoClusterSupport;
import org.simantics.acorn.backup.AcornBackupProvider;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.ClusterChange;
import org.simantics.acorn.internal.UndoClusterUpdateProcessor;
import org.simantics.acorn.lru.ClusterChangeSet;
import org.simantics.acorn.lru.ClusterInfo;
import org.simantics.acorn.lru.ClusterStreamChunk;
import org.simantics.acorn.lru.ClusterUpdateOperation;
import org.simantics.acorn.lru.LRUObject;
import org.simantics.backup.BackupException;
import org.simantics.db.ClusterCreator;
import org.simantics.db.Database;
import org.simantics.db.ServiceLocator;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.SDBException;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.service.ClusterSetsSupport;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.logging.TimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphClientImpl2
implements Database.Session {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphClientImpl2.class);
    public static final boolean DEBUG = false;
    final ClusterManager clusters;
    private TransactionManager transactionManager = new TransactionManager();
    private ExecutorService executor = Executors.newSingleThreadExecutor(new ClientThreadFactory("Core Main Program", false));
    private ExecutorService saver = Executors.newSingleThreadExecutor(new ClientThreadFactory("Core Snapshot Saver", true));
    private Path dbFolder;
    private final Database database;
    private ServiceLocator locator;
    private FileCache fileCache;
    private MainProgram mainProgram;
    private boolean closed = false;
    private boolean isClosing = false;
    private boolean unexpectedClose = false;

    public GraphClientImpl2(Database database, Path dbFolder, ServiceLocator locator) throws IOException {
        this.database = database;
        this.dbFolder = dbFolder;
        this.locator = locator;
        this.fileCache = new FileCache();
        locator.registerService(FileCache.class, (Object)this.fileCache);
        this.clusters = new ClusterManager(dbFolder, this.fileCache);
        this.load();
        ClusterSetsSupport cssi = (ClusterSetsSupport)locator.getService(ClusterSetsSupport.class);
        cssi.setReadDirectory(this.clusters.lastSessionDirectory);
        cssi.updateWriteDirectory(this.clusters.workingDirectory);
        this.mainProgram = new MainProgram(this, this.clusters);
        this.executor.execute(this.mainProgram);
    }

    public Path getDbFolder() {
        return this.dbFolder;
    }

    void tryMakeSnapshot() throws IOException {
        if (this.isClosing || this.unexpectedClose) {
            return;
        }
        this.saver.execute(new Runnable(){

            @Override
            public void run() {
                block27: {
                    Database.Session.Transaction tr = null;
                    try {
                        try {
                            tr = GraphClientImpl2.this.askWriteTransaction(-1L);
                            GraphClientImpl2.this.synchronizeWithIdleMainProgram(() -> GraphClientImpl2.this.makeSnapshot(false));
                        }
                        catch (IllegalAcornStateException | ProCoreException e) {
                            LOGGER.error("Snapshotting failed", (Throwable)e);
                            GraphClientImpl2.this.unexpectedClose = true;
                            try {
                                if (tr != null) {
                                    GraphClientImpl2.this.endTransaction(tr.getTransactionId());
                                }
                                if (!GraphClientImpl2.this.unexpectedClose) break block27;
                                LifecycleSupport support = (LifecycleSupport)GraphClientImpl2.this.getServiceLocator().getService(LifecycleSupport.class);
                                try {
                                    support.close();
                                }
                                catch (DatabaseException e1) {
                                    LOGGER.error("Failed to close database as a safety measure due to failed snapshotting", (Throwable)e1);
                                }
                            }
                            catch (ProCoreException e2) {
                                LOGGER.error("Failed to end snapshotting write transaction", (Throwable)e2);
                            }
                        }
                        catch (SDBException e) {
                            LOGGER.error("Snapshotting failed", (Throwable)e);
                            GraphClientImpl2.this.unexpectedClose = true;
                            try {
                                if (tr != null) {
                                    GraphClientImpl2.this.endTransaction(tr.getTransactionId());
                                }
                                if (!GraphClientImpl2.this.unexpectedClose) break block27;
                                LifecycleSupport support = (LifecycleSupport)GraphClientImpl2.this.getServiceLocator().getService(LifecycleSupport.class);
                                try {
                                    support.close();
                                }
                                catch (DatabaseException e1) {
                                    LOGGER.error("Failed to close database as a safety measure due to failed snapshotting", (Throwable)e1);
                                }
                            }
                            catch (ProCoreException e3) {
                                LOGGER.error("Failed to end snapshotting write transaction", (Throwable)e3);
                            }
                        }
                    }
                    finally {
                        try {
                            if (tr != null) {
                                GraphClientImpl2.this.endTransaction(tr.getTransactionId());
                            }
                            if (GraphClientImpl2.this.unexpectedClose) {
                                LifecycleSupport support = (LifecycleSupport)GraphClientImpl2.this.getServiceLocator().getService(LifecycleSupport.class);
                                try {
                                    support.close();
                                }
                                catch (DatabaseException e1) {
                                    LOGGER.error("Failed to close database as a safety measure due to failed snapshotting", (Throwable)e1);
                                }
                            }
                        }
                        catch (ProCoreException e) {
                            LOGGER.error("Failed to end snapshotting write transaction", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    private void makeSnapshot(boolean fullSave) throws IllegalAcornStateException {
        this.clusters.makeSnapshot(this.locator, fullSave);
    }

    public <T> T clone(ClusterUID uid, ClusterCreator creator) throws DatabaseException {
        try {
            return this.clusters.clone(uid, creator);
        }
        catch (IOException | AcornAccessVerificationException | IllegalAcornStateException e) {
            this.unexpectedClose = true;
            throw new DatabaseException((Throwable)e);
        }
    }

    private void load() throws IOException {
        this.clusters.load();
    }

    public Database getDatabase() {
        return this.database;
    }

    public void close() throws ProCoreException {
        LOGGER.info("Closing " + this + " and mainProgram " + this.mainProgram);
        if (!this.closed && !this.isClosing) {
            this.isClosing = true;
            try {
                if (!this.unexpectedClose) {
                    this.synchronizeWithIdleMainProgram(() -> this.makeSnapshot(true));
                }
                this.mainProgram.close();
                this.clusters.shutdown();
                this.executor.shutdown();
                this.saver.shutdown();
                boolean executorTerminated = this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
                boolean saverTerminated = this.saver.awaitTermination(500L, TimeUnit.MILLISECONDS);
                LOGGER.info("executorTerminated=" + executorTerminated + ", saverTerminated=" + saverTerminated);
                try {
                    this.clusters.mainState.save(this.dbFolder);
                }
                catch (IOException iOException) {
                    LOGGER.error("Failed to save main.state file in database folder " + this.dbFolder);
                }
                this.mainProgram = null;
                this.executor = null;
                this.saver = null;
            }
            catch (InterruptedException | IllegalAcornStateException e) {
                throw new ProCoreException((Throwable)e);
            }
            catch (SDBException e1) {
                throw new ProCoreException((Throwable)e1);
            }
            this.closed = true;
        }
    }

    public void open() throws ProCoreException {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() throws ProCoreException {
        return this.closed;
    }

    public void acceptCommit(long transactionId, long changeSetId, byte[] metadata) throws ProCoreException {
        ++this.clusters.state.headChangeSetId;
        long committedChangeSetId = changeSetId + 1L;
        try {
            this.clusters.commitChangeSet(committedChangeSetId, metadata);
            this.clusters.state.transactionId = transactionId;
            this.mainProgram.committed();
            TimeLogger.log((String)"Accepted commit");
        }
        catch (IllegalAcornStateException e) {
            throw new ProCoreException((Throwable)((Object)e));
        }
    }

    public long cancelCommit(long transactionId, long changeSetId, byte[] metadata, Database.Session.OnChangeSetUpdate onChangeSetUpdate) throws ProCoreException {
        this.acceptCommit(transactionId, changeSetId, metadata);
        try {
            this.undo(new long[]{changeSetId + 1L}, onChangeSetUpdate);
            ++this.clusters.state.headChangeSetId;
            return this.clusters.state.headChangeSetId;
        }
        catch (SDBException e) {
            LOGGER.error("Failed to undo cancelled transaction", (Throwable)e);
            throw new ProCoreException((Throwable)e);
        }
    }

    public Database.Session.Transaction askReadTransaction() throws ProCoreException {
        return this.transactionManager.askReadTransaction();
    }

    public Database.Session.Transaction askWriteTransaction(long transactionId) throws ProCoreException {
        try {
            if (this.isClosing || this.unexpectedClose || this.closed) {
                throw new ProCoreException("GraphClientImpl2 is already closing so no more write transactions allowed!");
            }
            return this.transactionManager.askWriteTransaction();
        }
        catch (IllegalAcornStateException e) {
            throw new ProCoreException((Throwable)((Object)e));
        }
    }

    public long endTransaction(long transactionId) throws ProCoreException {
        return this.transactionManager.endTransaction(transactionId);
    }

    public String execute(String command) throws ProCoreException {
        return "";
    }

    public byte[] getChangeSetMetadata(long changeSetId) throws ProCoreException {
        try {
            return this.clusters.getMetadata(changeSetId);
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw new ProCoreException((Throwable)e);
        }
    }

    public Database.Session.ChangeSetData getChangeSetData(long minChangeSetId, long maxChangeSetId, Database.Session.OnChangeSetUpdate onChangeSetupate) throws ProCoreException {
        new Exception("GetChangeSetDataFunction " + minChangeSetId + " " + maxChangeSetId).printStackTrace();
        return null;
    }

    public Database.Session.ChangeSetIds getChangeSetIds() throws ProCoreException {
        throw new UnsupportedOperationException();
    }

    public Database.Session.Cluster getCluster(byte[] clusterId) throws ProCoreException {
        throw new UnsupportedOperationException();
    }

    public Database.Session.ClusterChanges getClusterChanges(long changeSetId, byte[] clusterId) throws ProCoreException {
        throw new UnsupportedOperationException();
    }

    public Database.Session.ClusterIds getClusterIds() throws ProCoreException {
        try {
            return this.clusters.getClusterIds();
        }
        catch (IllegalAcornStateException e) {
            throw new ProCoreException((Throwable)((Object)e));
        }
    }

    public Database.Session.Information getInformation() throws ProCoreException {
        return new Database.Session.Information(){

            public String getServerId() {
                return "server";
            }

            public String getProtocolId() {
                return "";
            }

            public String getDatabaseId() {
                return "database";
            }

            public long getFirstChangeSetId() {
                return 0L;
            }
        };
    }

    public Database.Session.Refresh getRefresh(long changeSetId) throws ProCoreException {
        final Database.Session.ClusterIds ids = this.getClusterIds();
        return new Database.Session.Refresh(){

            public long getHeadChangeSetId() {
                return GraphClientImpl2.this.clusters.state.headChangeSetId;
            }

            public long[] getFirst() {
                return ids.getFirst();
            }

            public long[] getSecond() {
                return ids.getSecond();
            }
        };
    }

    public Database.Session.ResourceSegment getResourceSegment(byte[] clusterUID, int resourceIndex, long segmentOffset, short segmentSize) throws ProCoreException {
        try {
            return this.clusters.getResourceSegment(clusterUID, resourceIndex, segmentOffset, segmentSize);
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw new ProCoreException((Throwable)e);
        }
    }

    public long reserveIds(int count) throws ProCoreException {
        return this.clusters.state.reservedIds++;
    }

    public void updateCluster(byte[] operations) throws ProCoreException {
        LRUObject info = null;
        try {
            try {
                ClusterUpdateOperation operation = new ClusterUpdateOperation(this.clusters, operations);
                info = this.clusters.clusterLRU.getOrCreate(operation.uid, true);
                if (info == null) {
                    throw new IllegalAcornStateException("info == null for operation " + operation);
                }
                info.acquireMutex();
                ((ClusterInfo)info).scheduleUpdate();
                this.mainProgram.schedule(operation);
            }
            catch (AcornAccessVerificationException | IllegalAcornStateException e) {
                throw new ProCoreException((Throwable)e);
            }
        }
        finally {
            if (info != null) {
                info.releaseMutex();
            }
        }
    }

    private UndoClusterUpdateProcessor getUndoCSS(String ccsId) throws DatabaseException, AcornAccessVerificationException, IllegalAcornStateException {
        String[] ss = ccsId.split("\\.");
        String chunkKey = ss[0];
        int chunkOffset = Integer.parseInt(ss[1]);
        ClusterStreamChunk chunk = this.clusters.streamLRU.getWithoutMutex(chunkKey);
        if (chunk == null) {
            throw new IllegalAcornStateException("Cluster Stream Chunk " + chunkKey + " was not found.");
        }
        chunk.acquireMutex();
        try {
            UndoClusterUpdateProcessor undoClusterUpdateProcessor = chunk.getUndoProcessor(this.clusters, chunkOffset, ccsId);
            return undoClusterUpdateProcessor;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
        finally {
            chunk.releaseMutex();
        }
    }

    private void performUndo(String ccsId, ArrayList<Pair<ClusterUID, byte[]>> clusterChanges, UndoClusterSupport support) throws ProCoreException, DatabaseException, IllegalAcornStateException, AcornAccessVerificationException {
        UndoClusterUpdateProcessor proc = this.getUndoCSS(ccsId);
        int clusterKey = this.clusters.getClusterKeyByClusterUIDOrMakeWithoutMutex(proc.getClusterUID());
        this.clusters.clusterLRU.acquireMutex();
        try {
            ClusterChange cs = new ClusterChange(clusterChanges, proc.getClusterUID());
            int i = 0;
            while (i < proc.entries.size()) {
                ClusterChangeSet.Entry e = proc.entries.get(proc.entries.size() - 1 - i);
                e.process(this.clusters, cs, clusterKey);
                ++i;
            }
            cs.flush();
        }
        finally {
            this.clusters.clusterLRU.releaseMutex();
        }
    }

    private void synchronizeWithIdleMainProgram(final MainProgram.MainProgramRunnable runnable) throws SDBException {
        final Exception[] exception = new Exception[1];
        final Semaphore s = new Semaphore(0);
        this.mainProgram.runIdle(new MainProgram.MainProgramRunnable(){

            @Override
            public void success() {
                try {
                    runnable.success();
                }
                finally {
                    s.release();
                }
            }

            @Override
            public void error(Exception e) {
                exception[0] = e;
                try {
                    runnable.error(e);
                }
                finally {
                    s.release();
                }
            }

            @Override
            public void run() throws Exception {
                runnable.run();
            }
        });
        try {
            s.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalAcornStateException("Unhandled interruption.", e);
        }
        Exception e = exception[0];
        if (e != null) {
            if (e instanceof SDBException) {
                throw (SDBException)((Object)e);
            }
            if (e != null) {
                throw new IllegalAcornStateException(e);
            }
        }
    }

    public boolean undo(final long[] changeSetIds, final Database.Session.OnChangeSetUpdate onChangeSetUpdate) throws SDBException {
        this.synchronizeWithIdleMainProgram(new MainProgram.MainProgramRunnable(){

            @Override
            public void run() throws Exception {
                try {
                    final ArrayList clusterChanges = new ArrayList();
                    UndoClusterSupport support = new UndoClusterSupport(GraphClientImpl2.this.clusters);
                    final int changeSetId = GraphClientImpl2.this.clusters.state.headChangeSetId;
                    int i = 0;
                    while (i < changeSetIds.length) {
                        long id = changeSetIds[changeSetIds.length - 1 - i];
                        ArrayList<String> ccss = GraphClientImpl2.this.clusters.getChanges(id);
                        int j = 0;
                        while (j < ccss.size()) {
                            String ccsid = ccss.get(ccss.size() - j - 1);
                            try {
                                GraphClientImpl2.this.performUndo(ccsid, clusterChanges, support);
                            }
                            catch (DatabaseException e) {
                                LOGGER.error("failed to perform undo for cluster change set {}", (Object)ccsid, (Object)e);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < clusterChanges.size()) {
                        final int changeSetIndex = i;
                        Pair pair = (Pair)clusterChanges.get(i);
                        final ClusterUID cuid = (ClusterUID)pair.first;
                        final byte[] data = (byte[])pair.second;
                        onChangeSetUpdate.onChangeSetUpdate(new Database.Session.ChangeSetUpdate(){

                            public long getChangeSetId() {
                                return changeSetId;
                            }

                            public int getChangeSetIndex() {
                                return 0;
                            }

                            public int getNumberOfClusterChangeSets() {
                                return clusterChanges.size();
                            }

                            public int getIndexOfClusterChangeSet() {
                                return changeSetIndex;
                            }

                            public byte[] getClusterId() {
                                return cuid.asBytes();
                            }

                            public boolean getNewCluster() {
                                return false;
                            }

                            public byte[] getData() {
                                return data;
                            }
                        });
                        ++i;
                    }
                }
                catch (AcornAccessVerificationException | IllegalAcornStateException e1) {
                    throw new ProCoreException((Throwable)e1);
                }
            }
        });
        return false;
    }

    ServiceLocator getServiceLocator() {
        return this.locator;
    }

    public boolean refreshEnabled() {
        return false;
    }

    public boolean rolledback() {
        return this.clusters.rolledback();
    }

    private void purge() throws IllegalAcornStateException {
        this.clusters.purge(this.locator);
    }

    public void purgeDatabase() {
        if (this.isClosing || this.unexpectedClose) {
            return;
        }
        this.saver.execute(new Runnable(){

            @Override
            public void run() {
                block27: {
                    Database.Session.Transaction tr = null;
                    try {
                        try {
                            tr = GraphClientImpl2.this.askWriteTransaction(-1L);
                            GraphClientImpl2.this.synchronizeWithIdleMainProgram(() -> GraphClientImpl2.this.purge());
                        }
                        catch (IllegalAcornStateException | ProCoreException e) {
                            LOGGER.error("Purge failed", (Throwable)e);
                            GraphClientImpl2.this.unexpectedClose = true;
                            try {
                                if (tr != null) {
                                    GraphClientImpl2.this.endTransaction(tr.getTransactionId());
                                }
                                if (!GraphClientImpl2.this.unexpectedClose) break block27;
                                LifecycleSupport support = (LifecycleSupport)GraphClientImpl2.this.getServiceLocator().getService(LifecycleSupport.class);
                                try {
                                    support.close();
                                }
                                catch (DatabaseException e1) {
                                    LOGGER.error("Failed to close database as a safety measure due to failed purge", (Throwable)e1);
                                }
                            }
                            catch (ProCoreException e2) {
                                LOGGER.error("Failed to end purge write transaction", (Throwable)e2);
                            }
                        }
                        catch (SDBException e) {
                            LOGGER.error("Purge failed", (Throwable)e);
                            GraphClientImpl2.this.unexpectedClose = true;
                            try {
                                if (tr != null) {
                                    GraphClientImpl2.this.endTransaction(tr.getTransactionId());
                                }
                                if (!GraphClientImpl2.this.unexpectedClose) break block27;
                                LifecycleSupport support = (LifecycleSupport)GraphClientImpl2.this.getServiceLocator().getService(LifecycleSupport.class);
                                try {
                                    support.close();
                                }
                                catch (DatabaseException e1) {
                                    LOGGER.error("Failed to close database as a safety measure due to failed purge", (Throwable)e1);
                                }
                            }
                            catch (ProCoreException e3) {
                                LOGGER.error("Failed to end purge write transaction", (Throwable)e3);
                            }
                        }
                    }
                    finally {
                        try {
                            if (tr != null) {
                                GraphClientImpl2.this.endTransaction(tr.getTransactionId());
                            }
                            if (GraphClientImpl2.this.unexpectedClose) {
                                LifecycleSupport support = (LifecycleSupport)GraphClientImpl2.this.getServiceLocator().getService(LifecycleSupport.class);
                                try {
                                    support.close();
                                }
                                catch (DatabaseException e1) {
                                    LOGGER.error("Failed to close database as a safety measure due to failed purge", (Throwable)e1);
                                }
                            }
                        }
                        catch (ProCoreException e) {
                            LOGGER.error("Failed to end purge write transaction", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public long getTailChangeSetId() {
        return this.clusters.getTailChangeSetId();
    }

    public Future<BackupException> getBackupRunnable(Semaphore lock, Path targetPath, int revision) throws IllegalAcornStateException, IOException {
        this.makeSnapshot(true);
        Path dbDir = this.getDbFolder();
        int newestFolder = this.clusters.mainState.headDir - 1;
        int latestFolder = -2;
        Path AcornMetadataFile = AcornBackupProvider.getAcornMetadataFile(dbDir);
        if (Files.exists(AcornMetadataFile, new LinkOption[0])) {
            Throwable throwable = null;
            Object var9_10 = null;
            try (BufferedReader br = Files.newBufferedReader(AcornMetadataFile);){
                latestFolder = Integer.parseInt(br.readLine());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        AcornBackupProvider.AcornBackupRunnable r = new AcornBackupProvider.AcornBackupRunnable(lock, targetPath, revision, dbDir, latestFolder, newestFolder);
        new Thread((Runnable)r, "Acorn backup thread").start();
        return r;
    }

    private static class ClientThreadFactory
    implements ThreadFactory {
        final String name;
        final boolean daemon;

        public ClientThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.name);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }

    private class TransactionManager {
        private TransactionState currentTransactionState = TransactionState.IDLE;
        private int reads = 0;
        private LinkedList<TransactionRequest> requests = new LinkedList();
        private TLongObjectHashMap<TransactionRequest> requestMap = new TLongObjectHashMap();

        private TransactionManager() {
        }

        private synchronized Database.Session.Transaction makeTransaction(TransactionRequest req) {
            final int csId = GraphClientImpl2.this.clusters.state.headChangeSetId;
            final long trId = GraphClientImpl2.this.clusters.state.transactionId + 1L;
            this.requestMap.put(trId, (Object)req);
            return new Database.Session.Transaction(){

                public long getTransactionId() {
                    return trId;
                }

                public long getHeadChangeSetId() {
                    return csId;
                }
            };
        }

        private Database.Session.Transaction askReadTransaction() throws ProCoreException {
            Semaphore semaphore = new Semaphore(0);
            TransactionRequest req = this.queue(TransactionState.READ, semaphore);
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new ProCoreException((Throwable)e);
            }
            return this.makeTransaction(req);
        }

        private synchronized void dispatch() {
            TransactionRequest r = this.requests.removeFirst();
            if (r.state == TransactionState.READ) {
                ++this.reads;
            }
            r.semaphore.release();
        }

        private synchronized void processRequests() {
            while (true) {
                if (this.requests.isEmpty()) {
                    return;
                }
                TransactionRequest req = this.requests.peek();
                if (this.currentTransactionState == TransactionState.IDLE) {
                    this.currentTransactionState = req.state;
                    this.dispatch();
                    continue;
                }
                if (this.currentTransactionState == TransactionState.READ) {
                    if (req.state == this.currentTransactionState) {
                        this.dispatch();
                        continue;
                    }
                    return;
                }
                if (this.currentTransactionState == TransactionState.WRITE) break;
            }
        }

        private synchronized TransactionRequest queue(TransactionState state, Semaphore semaphore) {
            TransactionRequest req = new TransactionRequest(state, semaphore);
            this.requests.addLast(req);
            this.processRequests();
            return req;
        }

        private Database.Session.Transaction askWriteTransaction() throws IllegalAcornStateException {
            Semaphore semaphore = new Semaphore(0);
            TransactionRequest req = this.queue(TransactionState.WRITE, semaphore);
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new IllegalAcornStateException(e);
            }
            GraphClientImpl2.this.mainProgram.startTransaction(GraphClientImpl2.this.clusters.state.headChangeSetId + 1);
            return this.makeTransaction(req);
        }

        private synchronized long endTransaction(long transactionId) throws ProCoreException {
            TransactionRequest req = (TransactionRequest)this.requestMap.remove(transactionId);
            if (req.state == TransactionState.WRITE) {
                this.currentTransactionState = TransactionState.IDLE;
                this.processRequests();
            } else {
                --this.reads;
                if (this.reads == 0) {
                    this.currentTransactionState = TransactionState.IDLE;
                    this.processRequests();
                }
            }
            return GraphClientImpl2.this.clusters.state.transactionId;
        }
    }

    private class TransactionRequest {
        public TransactionState state;
        public Semaphore semaphore;

        public TransactionRequest(TransactionState state, Semaphore semaphore) {
            this.state = state;
            this.semaphore = semaphore;
        }
    }

    private static enum TransactionState {
        IDLE,
        WRITE,
        READ;

    }
}

