/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.sequences.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.simulation.sequences.action.ActionContext;

public abstract class AbstractActionContext
implements ActionContext {
    public static final double TIME_TOLERANCE = 1.0E-6;
    double currentTime;
    volatile boolean stopped;
    ArrayList<Function1<Tuple0, Object>> scheduledNow = new ArrayList();
    ArrayList<Function1<Tuple0, Object>> scheduledNextStep = new ArrayList();
    PriorityQueue<Task> scheduledAt = new PriorityQueue();
    public List<Exception> exceptions;

    @Override
    public double time() {
        return this.currentTime;
    }

    @Override
    public void scheduleNow(Function1<Tuple0, Object> continuation) {
        this.scheduledNow.add(continuation);
    }

    @Override
    public void scheduleNextStep(Function1<Tuple0, Object> continuation) {
        this.scheduledNextStep.add(continuation);
    }

    @Override
    public void scheduleAt(double time, Function1<Tuple0, Object> continuation) {
        if (time <= this.currentTime) {
            this.scheduleNow(continuation);
        } else {
            this.scheduledAt.add(new Task(time, continuation));
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        AbstractActionContext abstractActionContext = this;
        synchronized (abstractActionContext) {
            return this.stopped || this.scheduledNextStep.isEmpty() && this.scheduledAt.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double handleStep(double currentTime) {
        AbstractActionContext abstractActionContext = this;
        synchronized (abstractActionContext) {
            this.currentTime = currentTime;
            ArrayList<Function1<Tuple0, Object>> temp = this.scheduledNow;
            this.scheduledNow = this.scheduledNextStep;
            this.scheduledNextStep = temp;
            Collections.reverse(this.scheduledNow);
            SCLContext context = SCLContext.getCurrent();
            Object oldActionContext = context.put((Object)"sequenceAction", (Object)this);
            Task firstTask = this.scheduledAt.peek();
            while (true) {
                if (!this.scheduledNow.isEmpty()) {
                    try {
                        Function1<Tuple0, Object> currentContinuation = this.scheduledNow.remove(this.scheduledNow.size() - 1);
                        currentContinuation.apply((Object)Tuple0.INSTANCE);
                        currentContinuation = null;
                    }
                    catch (Exception e) {
                        if (this.exceptions == null) {
                            this.exceptions = new ArrayList<Exception>();
                        }
                        this.exceptions.add(new RuntimeException("Action failure at " + currentTime + ": " + e.getMessage(), e));
                    }
                    continue;
                }
                if (firstTask != null) break block17;
                break;
            }
            {
                catch (Throwable throwable) {
                    context.put((Object)"sequenceAction", oldActionContext);
                    throw throwable;
                }
            }
            {
                block18: {
                    block17: {
                        context.put((Object)"sequenceAction", oldActionContext);
                        return Double.POSITIVE_INFINITY;
                    }
                    if (!(firstTask.time > currentTime + 1.0E-6)) break block18;
                    double d = firstTask.time;
                    context.put((Object)"sequenceAction", oldActionContext);
                    return d;
                }
                firstTask.continuation.apply((Object)Tuple0.INSTANCE);
                AbstractActionContext abstractActionContext2 = this;
                synchronized (abstractActionContext2) {
                    this.scheduledAt.remove();
                }
                firstTask = this.scheduledAt.peek();
                continue;
            }
        }
    }

    private static class Task
    implements Comparable<Task> {
        final double time;
        final Function1<Tuple0, Object> continuation;

        public Task(double time, Function1<Tuple0, Object> continuation) {
            this.time = time;
            this.continuation = continuation;
        }

        @Override
        public int compareTo(Task o) {
            return Double.compare(this.time, o.time);
        }
    }
}

