/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.utils;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.InstantiateRequest;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.Functions;
import org.simantics.structural2.internal.queries.ConnectedTo;
import org.simantics.structural2.internal.queries.RelatedConnections;
import org.simantics.structural2.internal.queries.RelatedConnectionsOfConnectionJoin;
import org.simantics.structural2.queries.Terminal;
import org.simantics.structural2.variables.Connection;
import org.simantics.utils.datastructures.Pair;

public class StructuralUtils {
    public static Collection<Resource> getConnectionRelations(ReadGraph graph, Resource componentType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        return (Collection)graph.syncRequest((Read)new ObjectsWithType(componentType, L0.DomainOf, STR.ConnectionRelation));
    }

    public static Collection<Resource> getPropertyRelations(ReadGraph graph, Resource componentType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource relation : graph.getObjects(componentType, L0.DomainOf)) {
            if (!graph.isSubrelationOf(relation, L0.HasProperty)) continue;
            result.add(relation);
        }
        return result;
    }

    public static boolean isDomainOfRelation(ReadGraph graph, Resource componentType, Resource connectionRelation) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource domain : graph.getObjects(connectionRelation, L0.HasDomain)) {
            if (!graph.isInheritedFrom(componentType, domain)) continue;
            return true;
        }
        return false;
    }

    public static void addConnectionPoint(WriteGraph g, Resource componentType, Resource connectionPoint) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        g.claim(connectionPoint, L0.HasDomain, componentType);
    }

    public static Resource createConnectionPoint(WriteGraph g, Resource componentType, Resource copy) throws DatabaseException {
        String proposition = NameUtils.getSafeName((ReadGraph)g, (Resource)copy);
        String newName = NameUtils.findFreshName((ReadGraph)g, (String)proposition, (Resource)componentType);
        return StructuralUtils.createConnectionPoint(g, componentType, copy, newName);
    }

    public static Resource createConnectionPoint(WriteGraph g, Resource componentType, Resource copy, String name) throws DatabaseException {
        return (Resource)StructuralUtils.createConnectionPointP((WriteGraph)g, (Resource)componentType, (Resource)copy, (String)name).first;
    }

    public static Pair<Resource, Resource> createConnectionPointP(WriteGraph g, Resource componentType, Resource copy, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        Resource connectionPoint = g.newResource();
        Resource connectionPointInv = g.newResource();
        for (Resource superrelation : g.getObjects(copy, L0.SubrelationOf)) {
            g.claim(connectionPoint, L0.SubrelationOf, null, superrelation);
            Resource inverse = g.getPossibleInverse(superrelation);
            if (inverse == null) continue;
            g.claim(connectionPointInv, L0.SubrelationOf, null, inverse);
        }
        for (Resource type : g.getObjects(copy, L0.InstanceOf)) {
            g.claim(connectionPoint, L0.InstanceOf, null, type);
        }
        for (Resource attachment : g.getObjects(copy, STR.HasAttachmentRelation)) {
            g.claim(connectionPoint, STR.HasAttachmentRelation, attachment);
        }
        for (Statement stm : g.getStatements(copy, STR.AllowsConnectionType)) {
            if (stm.isAsserted(copy)) continue;
            g.claim(connectionPoint, stm.getPredicate(), stm.getObject());
        }
        g.claim(connectionPoint, L0.InverseOf, connectionPointInv);
        g.claimLiteral(connectionPoint, L0.HasName, (Object)name, (Binding)Bindings.STRING);
        g.claim(connectionPoint, L0.ConsistsOf, connectionPointInv);
        g.claimLiteral(connectionPointInv, L0.HasName, (Object)"Inverse", (Binding)Bindings.STRING);
        StructuralUtils.addConnectionPoint(g, componentType, connectionPoint);
        g.claim(componentType, L0.ConsistsOf, connectionPoint);
        return Pair.make((Object)connectionPoint, (Object)connectionPointInv);
    }

    public static Resource newComponent(WriteGraph g, Resource parent, String name, Resource componentType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        HashMap<String, Resource> parameters = new HashMap<String, Resource>();
        parameters.put("parent", parent);
        InstantiateRequest ir = new InstantiateRequest(componentType, parameters);
        Resource component = ir.perform(g);
        g.claim(component, L0.HasName, Layer0Utils.literal((WriteGraph)g, (String)name));
        g.claim(component, L0.HasLabel, Layer0Utils.literal((WriteGraph)g, (String)""));
        g.claim(parent, L0.ConsistsOf, component);
        Layer0Utils.claimNewIdentifier((WriteGraph)g, (Resource)component, (boolean)true);
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Created component " + component));
        return component;
    }

    public static Collection<Resource> getChildComponents(ReadGraph g, Resource parent) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        Collection allChildren = g.getObjects(parent, L0.ConsistsOf);
        ArrayList<Resource> result = new ArrayList<Resource>(allChildren.size());
        for (Resource child : allChildren) {
            if (!g.isInstanceOf(child, STR.Component)) continue;
            result.add(child);
        }
        return result;
    }

    @Deprecated
    public static Resource getComponentType(ReadGraph g, Resource component) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        return g.getPossibleType(component, STR.Component);
    }

    public static Resource getComponentTypeDefinition(ReadGraph g, Resource componentType) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        return g.getPossibleObject(componentType, STR.IsDefinedBy);
    }

    public static Set<Terminal> getRelatedTerminals(RequestProcessor g, Resource component, Resource connectionRelation) throws DatabaseException {
        return (Set)g.syncRequest((Read)new ConnectedTo(component, connectionRelation));
    }

    public static Set<Resource> getRelatedConnections(RequestProcessor g, Resource connection) throws DatabaseException {
        return (Set)g.syncRequest((Read)new RelatedConnections(connection));
    }

    public static Set<Resource> getRelatedConnectionsOfConnectionJoin(RequestProcessor g, Resource connectionJoin) throws DatabaseException {
        return (Set)g.syncRequest((Read)new RelatedConnectionsOfConnectionJoin(connectionJoin));
    }

    public static Set<Resource> getRelatedConnectionsOfConnectionJoin(RequestProcessor g, Resource connectionJoin, Collection<Resource> excludedConnections) throws DatabaseException {
        return (Set)g.syncRequest((Read)new RelatedConnectionsOfConnectionJoin(connectionJoin, excludedConnections));
    }

    public static boolean isConnectionInComposite(ReadGraph g, Resource connection, Resource composite) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Collection connects = g.getObjects(connection, STR.Connects);
        if (!connects.isEmpty()) {
            for (Resource component : connects) {
                for (Resource parent : g.getObjects(component, L0.PartOf)) {
                    if (!parent.equals(composite)) continue;
                    return true;
                }
            }
        } else {
            Set joinedComposites = null;
            for (Resource join : g.getObjects(connection, STR.IsJoinedBy)) {
                Collection joined = g.getObjects(join, STR.JoinsComposite);
                if (joinedComposites == null) {
                    joinedComposites = new THashSet(joined);
                    continue;
                }
                joinedComposites.retainAll(joined);
            }
            if (joinedComposites != null && joinedComposites.size() == 1) {
                return joinedComposites.contains(composite);
            }
        }
        return false;
    }

    public static Variable getConnectionPoint(ReadGraph graph, Variable component, Resource relation) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String relationName = (String)graph.getRelatedValue(relation, L0.HasName, (Binding)Bindings.STRING);
        return component.getProperty(graph, relationName);
    }

    public static Variable getPossibleConnectionPoint(ReadGraph graph, Variable component, Resource relation) throws DatabaseException {
        try {
            return StructuralUtils.getConnectionPoint(graph, component, relation);
        }
        catch (MissingVariableException missingVariableException) {
            return null;
        }
    }

    public static Variable getPossibleConnectionTo(ReadGraph graph, Variable component, Resource relation) throws DatabaseException {
        Variable property = component.getPossibleProperty(graph, relation);
        if (property == null) {
            return null;
        }
        Connection conn = (Connection)property.getPossibleValue(graph);
        if (conn == null) {
            return null;
        }
        Collection<Variable> cps = conn.getConnectionPoints(graph, null);
        if (cps.size() == 2) {
            for (Variable var : cps) {
                if (property.equals(var)) continue;
                return var;
            }
        }
        return null;
    }

    public static boolean isImmutable(ReadGraph graph, Resource r) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource uc = (Resource)graph.syncRequest((Read)new PossibleTypedParent(r, STR.ComponentType));
        return graph.isImmutable(r) || uc != null && (Layer0Utils.isPublished((ReadGraph)graph, (Resource)uc) || graph.hasStatement(uc, STR.ComponentType_Locked)) || Layer0Utils.isContainerPublished((ReadGraph)graph, (Resource)r);
    }

    public static List<Variable> structuralConnectionConnectionPoints(ReadGraph graph, Connection conn, Resource relationType) throws DatabaseException {
        return new ArrayList<Variable>(conn.getConnectionPoints(graph, relationType));
    }

    public static Resource structuralTypeResource(ReadGraph graph, Variable component, Resource baseType) throws DatabaseException {
        Functions.StructuralOverrideData od = Functions.StructuralOverrideData.compute(graph, component);
        return od.type();
    }

    public static Resource getComponentType(ReadGraph graph, Variable configuration, Resource component) throws DatabaseException {
        Variable componentVariable = configuration.browse(graph, component);
        return componentVariable.getType(graph);
    }

    public static Resource getPossibleComponentType(ReadGraph graph, Variable configuration, Resource component) throws DatabaseException {
        Variable componentVariable = configuration.browsePossible(graph, component);
        if (componentVariable == null) {
            return null;
        }
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        return componentVariable.getPossibleType(graph, STR.Component);
    }

    public static enum StructuralComponentClass {
        PRIMITIVE,
        REPLACEABLE,
        DEFINED,
        PROCEDURAL;


        public static StructuralComponentClass get(ReadGraph graph, Resource componentType) throws DatabaseException {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Set types = graph.getTypes(componentType);
            if (types.contains(STR.ProceduralComponentType)) {
                return PROCEDURAL;
            }
            if (graph.hasStatement(componentType, STR.IsDefinedBy)) {
                return DEFINED;
            }
            if (types.contains(STR.ReplaceableDefinedComponentType)) {
                return REPLACEABLE;
            }
            return PRIMITIVE;
        }
    }
}

