/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.formula;

import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.binding.mutable.Variant;

public enum FormulaError2 {
    _NO_ERROR(-1, "(no error)"),
    NULL(0, "#NULL"),
    DIV0(7, "#DIV/0!"),
    VALUE(15, "#VALUE!"),
    REF(23, "#REF!"),
    NAME(29, "#NAME?"),
    NUM(36, "#NUM!"),
    NA(42, "#N/A"),
    CIRCULAR_REF(-60, "~CIRCULAR~REF~"),
    FUNCTION_NOT_IMPLEMENTED(-30, "~FUNCTION~NOT~IMPLEMENTED~");

    private final String text;
    private static Map<String, FormulaError2> smap;

    static {
        smap = new HashMap<String, FormulaError2>();
        FormulaError2[] formulaError2Array = FormulaError2.values();
        int n = formulaError2Array.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaError2 error = formulaError2Array[n2];
            smap.put(error.getString(), error);
            ++n2;
        }
    }

    private FormulaError2(int type, String text) {
        this.text = text;
    }

    public String getString() {
        return this.text;
    }

    public static FormulaError2 forString(String errorName) {
        FormulaError2 err = smap.get(errorName);
        return err;
    }

    public static FormulaError2 forObject(Object errorObj) {
        if (errorObj instanceof Variant) {
            return FormulaError2.forString(((Variant)errorObj).getValue().toString());
        }
        return FormulaError2.forString(errorObj.toString());
    }

    public static String handleErrorCall(Object value) {
        if (value == null) {
            return VALUE.getString();
        }
        FormulaError2 error = FormulaError2.forObject(value);
        if (error != null) {
            return error.getString();
        }
        return VALUE.getString();
    }
}

