/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.lang.reflect.Constructor;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.osgi.framework.Bundle;
import org.simantics.db.Resource;
import org.simantics.diagram.ui.WorkbenchSelectionProvider;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.modeling.ui.diagramEditor.DiagramViewer;
import org.simantics.modeling.ui.diagramEditor.DiagramViewerSelectionProvider;
import org.simantics.modeling.ui.diagramEditor.DisposingPolicy;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.ui.workbench.IResourceEditorPart2;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.utils.DataContainer;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.ui.ErrorLogger;

public class DiagramEditor
extends EditorPart
implements IResourceEditorPart2,
IPartListener2,
DiagramViewer.DiagramViewerHost,
IExecutableExtension {
    public static final String ARG_VIEWER = "viewer";
    private Composite parent;
    private String viewerContributor;
    private String viewerClassName;
    private ResourceEditorSupport support;
    private DiagramViewer viewer;
    protected DataContainer<IDiagram> diagramContainer = new DataContainer();
    protected IThreadWorkQueue swt;
    protected WorkbenchSelectionProvider selectionProvider;
    private static final DisposingPolicy DISPOSING_POLICY = new DisposingPolicy();
    private Runnable disposer = () -> this.tryDisposeViewer();

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        if (data instanceof String) {
            String[] parameters;
            this.viewerContributor = cfig.getContributor().getName();
            String[] stringArray = parameters = ((String)data).split(";");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] keyValue = parameter.split("=");
                if (keyValue.length > 2) {
                    ErrorLogger.defaultLogWarning((String)("Invalid parameter '" + parameter + ". Complete view argument: " + data), null);
                } else {
                    String value;
                    String key = keyValue[0];
                    String string = value = keyValue.length > 1 ? keyValue[1] : "";
                    if (ARG_VIEWER.equals(key)) {
                        this.viewerClassName = value;
                    }
                }
                ++n2;
            }
        }
    }

    protected DiagramViewer createViewer() throws PartInitException {
        if (this.viewerClassName == null) {
            throw new PartInitException("DiagramViewer contributor class was not specified in editor extension's class attribute viewer-argument. contributor is '" + this.viewerContributor + "'");
        }
        try {
            Bundle b = Platform.getBundle((String)this.viewerContributor);
            if (b == null) {
                throw new PartInitException("DiagramViewer '" + this.viewerClassName + "' contributor bundle '" + this.viewerContributor + "' was not found in the platform.");
            }
            Class clazz = b.loadClass(this.viewerClassName);
            if (!DiagramViewer.class.isAssignableFrom(clazz)) {
                throw new PartInitException("DiagramViewer class '" + this.viewerClassName + "' is not assignable to " + DiagramViewer.class + ".");
            }
            Constructor ctor = clazz.getConstructor(new Class[0]);
            return (DiagramViewer)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PartInitException("Failed to instantiate DiagramViewer implementation '" + this.viewerClassName + "' from bundle '" + this.viewerContributor + "'. See exception for details.", (Throwable)e);
        }
    }

    public IResourceEditorInput getResourceInput() {
        return this.viewer.getResourceInput();
    }

    public IResourceEditorInput2 getResourceInput2() {
        return this.viewer.getResourceInput2();
    }

    public DiagramViewer getViewer() {
        return this.viewer;
    }

    public Resource getRuntimeResource() {
        DiagramViewer viewer = this.viewer;
        return viewer != null ? viewer.getRuntime() : null;
    }

    public Resource getInputResource() {
        DiagramViewer viewer = this.viewer;
        return viewer != null ? viewer.getInputResource() : null;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.viewer = this.createViewer();
        this.swt = SWTThread.getThreadAccess((Display)PlatformUI.getWorkbench().getDisplay());
        this.selectionProvider = this.createSelectionProvider();
        this.viewer.init(this, site, input, this.diagramContainer, this.selectionProvider);
        this.getSite().getPage().addPartListener((IPartListener2)this);
        this.support = new ResourceEditorSupport((IEditorPart)this, this.viewer.getInputValidator());
        this.support.activateValidation();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.initializeViewer();
    }

    private void initializeViewer() {
        this.parent.setBackground(this.parent.getDisplay().getSystemColor(1));
        this.viewer.createPartControl(this.parent);
        if (this.parent.isDisposed()) {
            return;
        }
        this.parent.layout(true);
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    protected WorkbenchSelectionProvider createSelectionProvider() {
        return new DiagramViewerSelectionProvider(this.swt, this.getSite(), this.diagramContainer);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DiagramViewer.class) {
            return (T)this.viewer;
        }
        if (this.viewer == null) {
            return (T)super.getAdapter(adapter);
        }
        T result = this.viewer.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        return (T)super.getAdapter(adapter);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this);
        if (this.support != null) {
            this.support.dispose();
            this.support = null;
        }
        DISPOSING_POLICY.removeDisposer(this.disposer);
        this.tryDisposeViewer();
        super.dispose();
    }

    @Override
    public void doSetPartName(String name) {
        this.setPartName(name);
    }

    @Override
    public void doSetTitleToolTip(String name) {
        this.setTitleToolTip(name);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (this.equals(part)) {
            DISPOSING_POLICY.addDisposer(this.disposer);
        }
    }

    private void tryDisposeViewer() {
        if (this.viewer != null) {
            Composite viewerComposite = this.viewer.getComposite();
            this.viewer.dispose();
            this.viewer = null;
            if (viewerComposite != null) {
                viewerComposite.dispose();
            }
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (this.equals(part)) {
            DISPOSING_POLICY.removeDisposer(this.disposer);
            if (this.viewer == null) {
                try {
                    this.viewer = this.createViewer();
                    this.viewer.init(this, this.getEditorSite(), this.getEditorInput(), this.diagramContainer, this.selectionProvider);
                    this.initializeViewer();
                }
                catch (PartInitException e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void reinitializeViewer() {
        if (this.viewer != null) {
            DISPOSING_POLICY.removeDisposer(this.disposer);
            this.tryDisposeViewer();
            try {
                this.viewer = this.createViewer();
                this.viewer.init(this, this.getEditorSite(), this.getEditorInput(), this.diagramContainer, this.selectionProvider);
                this.initializeViewer();
            }
            catch (PartInitException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
    }

    public static void reinitializeDiagram(Predicate<IEditorInput> predicate) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorRef = iEditorReferenceArray[n6];
                    try {
                        IEditorPart editor;
                        IEditorInput input = editorRef.getEditorInput();
                        if (predicate.test(input) && (editor = editorRef.getEditor(false)) instanceof DiagramEditor) {
                            ((DiagramEditor)editor).reinitializeViewer();
                        }
                    }
                    catch (PartInitException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void reinitializeDiagram(Resource diagram) {
        DiagramEditor.reinitializeDiagram((IEditorInput input) -> input instanceof IResourceEditorInput && ((IResourceEditorInput)input).getResource().equals(diagram));
    }

    public static void reinitializeDiagram(Set<Resource> diagrams) {
        DiagramEditor.reinitializeDiagram((IEditorInput input) -> input instanceof IResourceEditorInput && diagrams.contains(((IResourceEditorInput)input).getResource()));
    }
}

