/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.swt.core.widget;

import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.utils.strings.StringInputProblem;
import org.simantics.utils.strings.StringInputValidator;
import org.simantics.utils.ui.widgets.ITrackedColorProvider;
import org.simantics.utils.ui.widgets.TrackedModifyEvent;
import org.simantics.utils.ui.widgets.TrackedModifyListener;
import org.simantics.utils.ui.widgets.TrackedText;

public class TrackedTextWidget
extends LeafWidgetManager<Text> {
    @Override
    protected void doUpdateProperties(final SWTDocument document, Text control, JSONObject object) {
        if (control.isDisposed()) {
            return;
        }
        TrackedText tt = (TrackedText)control.getData("TrackedTextKey");
        String text = (String)object.getJSONField("text");
        final AbstractEventHandler onModify = (AbstractEventHandler)object.getJSONField("onModify");
        final StringInputValidator validator = (StringInputValidator)object.getJSONField("validator");
        RGB.Integer invalidBackground = (RGB.Integer)object.getBeanJSONFieldDefault("invalidBackground", RGB.Integer.BINDING, (Object)new RGB.Integer(255, 255, 255));
        RGB.Integer inactiveBackground = (RGB.Integer)object.getBeanJSONFieldDefault("inactiveBackground", RGB.Integer.BINDING, (Object)new RGB.Integer(255, 255, 255));
        RGB.Integer hoverBackground = (RGB.Integer)object.getBeanJSONFieldDefault("hoverBackground", RGB.Integer.BINDING, (Object)new RGB.Integer(255, 255, 255));
        RGB.Integer editingBackground = (RGB.Integer)object.getBeanJSONFieldDefault("editingBackground", RGB.Integer.BINDING, (Object)new RGB.Integer(255, 255, 255));
        RGB.Integer foreground = (RGB.Integer)object.getBeanJSONFieldDefault("foreground", RGB.Integer.BINDING, (Object)new RGB.Integer(0, 0, 0));
        Font font = (Font)object.getBeanJSONFieldDefault("font", Font.BINDING, (Object)new Font("Arial", 10, "Normal"));
        final Color invalid = document.getColor(invalidBackground);
        final Color inactive = document.getColor(inactiveBackground);
        final Color hover = document.getColor(hoverBackground);
        final Color editing = document.getColor(editingBackground);
        tt.setColorProvider(new ITrackedColorProvider(){

            public Color getInvalidBackground() {
                return invalid;
            }

            public Color getInactiveBackground() {
                return inactive;
            }

            public Color getHoverBackground() {
                return hover;
            }

            public Color getEditingBackground() {
                return editing;
            }
        });
        if (text != null) {
            tt.setTextWithoutNotify(text);
        } else {
            System.err.println(this + " text == null");
        }
        tt.setEditable(true);
        tt.addModifyListener(new TrackedModifyListener(){

            public void modifyText(TrackedModifyEvent e) {
                CommandContextImpl parameters = new CommandContextImpl();
                parameters.putString("text", e.getText());
                document.post(onModify, (CommandContext)parameters);
            }
        });
        if (validator != null) {
            tt.setInputValidator(new IInputValidator(){

                public String isValid(String newText) {
                    Collection problems = validator.validate(newText);
                    if (problems.isEmpty()) {
                        return null;
                    }
                    if (problems.size() == 1) {
                        return ((StringInputProblem)problems.iterator().next()).getDescription();
                    }
                    return problems.toString();
                }
            });
        }
        control.setFont(document.getFont(font));
        control.setForeground(document.getColor(foreground));
    }

    @Override
    protected Text doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
        Boolean hscroll;
        Boolean vscroll;
        int style = 0;
        Boolean multiLine = (Boolean)object.getJSONFieldDefault("multiLine", (Object)false);
        if (Boolean.TRUE.equals(multiLine)) {
            style |= 2;
        }
        if (Boolean.TRUE.equals(vscroll = (Boolean)object.getJSONFieldDefault("VScroll", (Object)false))) {
            style |= 0x200;
        }
        if (Boolean.TRUE.equals(hscroll = (Boolean)object.getJSONFieldDefault("HScroll", (Object)false))) {
            style |= 0x100;
        }
        TrackedText tt = new TrackedText(parent, style);
        return tt.getWidget();
    }
}

